/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.creation;

import com.gfycat.common.utils.Logging;
import java.io.IOException;
import okio.Buffer;
import okio.ForwardingSource;
import okio.Source;

public class ProgressReportingSource
extends ForwardingSource {
    private long totalBytesRead;
    private final long contentLength;
    private final ProgressListener progressListener;
    private int lastProgress = Integer.MAX_VALUE;

    public ProgressReportingSource(Source delegate, long contentLength, ProgressListener progressListener) {
        super(delegate);
        this.contentLength = contentLength;
        this.progressListener = progressListener;
    }

    public long read(Buffer sink, long byteCount) throws IOException {
        long bytesRead = super.read(sink, byteCount);
        if (bytesRead > 0L) {
            this.totalBytesRead += bytesRead;
            this.notifyIfChanged((int)(100L * this.totalBytesRead / this.contentLength));
        }
        return bytesRead;
    }

    public void close() throws IOException {
        super.close();
        Logging.d((String)"GfycatCreationService", (String)"ProgressReportingSource::close()");
    }

    private void notifyIfChanged(int progress) {
        if (progress != this.lastProgress) {
            this.lastProgress = progress;
            this.progressListener.onProgress(this.lastProgress);
        }
    }

    public static interface ProgressListener {
        public void onProgress(int var1);
    }
}

