/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.creation;

import com.gfycat.common.utils.Logging;
import com.gfycat.core.creation.ProgressReportingSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.apache.commons.io.IOUtils;

public class InputStreamRequestBody
extends RequestBody {
    private final InputStream inputStream;
    private final MediaType mediaType;
    private final ProgressReportingSource.ProgressListener listener;

    public InputStreamRequestBody(MediaType mediaType, InputStream inputStream, ProgressReportingSource.ProgressListener listener) {
        this.inputStream = inputStream;
        this.mediaType = mediaType;
        this.listener = listener;
    }

    public long contentLength() throws IOException {
        int result = Integer.MIN_VALUE;
        try {
            result = this.inputStream.available();
            long l = result;
            return l;
        }
        catch (IOException e) {
            Logging.d((String)"GfycatCreationService", (Throwable)e, (Object[])new Object[]{"InputStreamRequestBody::contentLength() = IOException"});
            throw e;
        }
        finally {
            Logging.d((String)"GfycatCreationService", (String)("InputStreamRequestBody::contentLength() = " + result));
        }
    }

    public MediaType contentType() {
        return this.mediaType;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        Logging.d((String)"GfycatCreationService", (String)"InputStreamRequestBody::writeTo()");
        ProgressReportingSource source = null;
        try {
            source = new ProgressReportingSource(Okio.source((InputStream)this.inputStream), this.contentLength(), this.listener);
            sink.writeAll((Source)source);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(source);
            throw throwable;
        }
        Util.closeQuietly((Closeable)((Object)source));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        IOUtils.closeQuietly((InputStream)this.inputStream);
    }
}

