/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.creation;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Utils;
import com.gfycat.core.creation.CreationAPI;
import com.gfycat.core.creation.InputStreamRequestBody;
import com.gfycat.core.creation.UploadListener;
import com.gfycat.core.creation.UploadManager;
import com.gfycat.core.creation.pojo.CreateGfycatRequest;
import com.gfycat.core.creation.pojo.CreatedGfycat;
import com.gfycat.core.creation.pojo.CreationStatus;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import retrofit2.HttpException;

public class DefaultUploadManager
implements UploadManager {
    private static final UploadListener DUMMY_LISTENER = (stage, progress) -> {};
    private static final int MAX_PROGRESS_VALUE = 100;
    private static final String STATUS_COMPLETE = "complete";
    private static final String STATUS_ERROR = "error";
    private final long DEFAULT_EXPECTED_CREATION_TIME_MS = TimeUnit.MINUTES.toMillis(3L);
    private final long DEFAULT_INITIAL_TIMEOUT_TIME_MS = TimeUnit.SECONDS.toMillis(10L);
    private final long DEFAULT_PING_TIMEOUT_TIME_MS = TimeUnit.SECONDS.toMillis(5L);
    private final CreationAPI creationAPI;
    private final OkHttpClient uploadClient;
    private final GetGfycatByName getGfycatByName;
    private final String fileUploadEndpoint;
    private final long expectedCreationTimeMs;
    private final long initialTimeoutMs;
    private final long pingTimeoutMs;

    public DefaultUploadManager(@NonNull CreationAPI creationAPI, @NonNull OkHttpClient uploadClient, @NonNull String fileUploadEndpoint, @NonNull GetGfycatByName getGfycatByName) {
        this.creationAPI = creationAPI;
        this.uploadClient = uploadClient;
        this.fileUploadEndpoint = fileUploadEndpoint;
        this.getGfycatByName = getGfycatByName;
        this.expectedCreationTimeMs = this.DEFAULT_EXPECTED_CREATION_TIME_MS;
        this.initialTimeoutMs = this.DEFAULT_INITIAL_TIMEOUT_TIME_MS;
        this.pingTimeoutMs = this.DEFAULT_PING_TIMEOUT_TIME_MS;
    }

    public DefaultUploadManager(@NonNull CreationAPI creationAPI, @NonNull OkHttpClient uploadClient, @NonNull String fileUploadEndpoint, @NonNull GetGfycatByName getGfycatByName, long expected, long initial, long ping) {
        this.creationAPI = creationAPI;
        this.uploadClient = uploadClient;
        this.fileUploadEndpoint = fileUploadEndpoint;
        this.getGfycatByName = getGfycatByName;
        this.expectedCreationTimeMs = expected;
        this.initialTimeoutMs = initial;
        this.pingTimeoutMs = ping;
    }

    @Override
    public String requestCreationKey(CreateGfycatRequest creationParams) throws UploadManager.CanNotCreateKeyException {
        retrofit2.Response result;
        try {
            result = this.creationAPI.createGfycat(creationParams).execute();
        }
        catch (IOException e) {
            throw new UploadManager.CanNotCreateKeyException("IOException during createGfycat request", e);
        }
        if (!result.isSuccessful()) {
            throw new UploadManager.CanNotCreateKeyException("CreationAPI.createGfycat was not successful. code = " + result.code() + " message = " + result.message());
        }
        CreatedGfycat createdGfycat = (CreatedGfycat)result.body();
        if (TextUtils.isEmpty((CharSequence)createdGfycat.getGfyname())) {
            Assertions.fail((Throwable)new IllegalStateException("Created gfyname is empty but request is successful."));
            throw new UploadManager.CanNotCreateKeyException("CreatedGfycat response is not ok = [" + createdGfycat + "]");
        }
        return createdGfycat.getGfyname();
    }

    @Override
    public void upload(String creationKey, InputStream inputStream) throws UploadManager.CanNotUploadGfycatException {
        this.upload(creationKey, inputStream, DUMMY_LISTENER);
    }

    @Override
    public void upload(String creationKey, InputStream inputStream, UploadListener listener) throws UploadManager.CanNotUploadGfycatException {
        try {
            listener.onUpdate(UploadListener.Stage.UPLOADING, 0);
            Request uploadRequest = new Request.Builder().url(this.fileUploadEndpoint + creationKey).put((RequestBody)new InputStreamRequestBody(MediaType.parse((String)("filename=" + creationKey)), inputStream, progress -> listener.onUpdate(UploadListener.Stage.UPLOADING, progress))).build();
            Response uploadResponse = this.uploadClient.newCall(uploadRequest).execute();
            if (!uploadResponse.isSuccessful()) {
                throw new UploadManager.CanNotUploadGfycatException("File uploading was not successful. code = " + uploadResponse.code() + " message = " + uploadResponse.message());
            }
            listener.onUpdate(UploadListener.Stage.UPLOADING, 100);
        }
        catch (IOException e) {
            throw new UploadManager.CanNotUploadGfycatException("IOException during content uploading", e);
        }
    }

    @Override
    public Gfycat waitUntilReady(@NonNull String creationKey) throws UploadManager.CanNotGetGfycatStatusException, UploadManager.FailedToCreateGfycatException, UploadManager.GfycatWasDeletedBeforeCompletionException {
        return this.waitUntilReady(creationKey, 180000L);
    }

    @Override
    public Gfycat waitUntilReady(@NonNull String creationKey, long timeout) throws UploadManager.CanNotGetGfycatStatusException, UploadManager.FailedToCreateGfycatException, UploadManager.GfycatWasDeletedBeforeCompletionException {
        if (TextUtils.isEmpty((CharSequence)creationKey)) {
            throw new IllegalArgumentException("Creation key is empty.");
        }
        CreationStatus creationStatus = null;
        long startTime = System.currentTimeMillis();
        int tryCount = 0;
        do {
            try {
                long timeTillTimeout = Math.max(0L, System.currentTimeMillis() + timeout - startTime);
                long defaultSleepTime = tryCount == 0 ? this.initialTimeoutMs : this.pingTimeoutMs;
                Thread.sleep(Math.min(timeTillTimeout, defaultSleepTime));
            }
            catch (InterruptedException e) {
                throw new UploadManager.CanNotGetGfycatStatusException(creationKey, "InterruptedException happened", e);
            }
            try {
                retrofit2.Response creationStatusResponse = this.creationAPI.getCreationStatus(creationKey).execute();
                if (!creationStatusResponse.isSuccessful()) {
                    throw new UploadManager.CanNotGetGfycatStatusException(creationKey, "creationStatusResponse is not successful (" + creationKey + ") code = " + creationStatusResponse.code() + " message = " + creationStatusResponse.message());
                }
                CreationStatus localCreationStatus = (CreationStatus)creationStatusResponse.body();
                if (STATUS_ERROR.equals(localCreationStatus.getTask())) {
                    throw new UploadManager.FailedToCreateGfycatException(creationKey, localCreationStatus.getDescription());
                }
                if (this.isCreationEnded(creationKey, localCreationStatus)) {
                    creationStatus = localCreationStatus;
                    break;
                }
            }
            catch (IOException e) {
                throw new UploadManager.CanNotGetGfycatStatusException(creationKey, "IOException while accessing CreationApi.getCreationStatus(" + creationKey + ")", e);
            }
            ++tryCount;
        } while (startTime + this.expectedCreationTimeMs > System.currentTimeMillis());
        if (creationStatus == null) {
            throw new UploadManager.CreationTimeoutException(creationKey, "Status tracking ended by timeout");
        }
        try {
            return this.getGfycatByName.getGfycat(creationKey);
        }
        catch (IOException e) {
            throw new UploadManager.CanNotGetGfycatStatusException(creationKey, "Creation ends, can not get Gfycat object from server", e);
        }
        catch (Throwable throwable) {
            if (this.is404(throwable)) {
                throw new UploadManager.GfycatWasDeletedBeforeCompletionException(creationKey, throwable);
            }
            Assertions.fail((Throwable)new IllegalStateException("getGfycatByName.getGfycat() throws throwable creationKey = " + creationKey + " creationStatus = " + creationStatus, throwable));
            throw new UploadManager.CanNotGetGfycatStatusException(creationKey, "Creation ends, can not get Gfycat object from server", throwable);
        }
    }

    private boolean is404(Throwable throwable) {
        return throwable instanceof HttpException && ((HttpException)throwable).code() == 404 || throwable.getCause() != null && this.is404(throwable.getCause());
    }

    @Override
    public Gfycat createGfycat(CreateGfycatRequest creationParams, InputStream inputStream) throws UploadManager.CanNotCreateKeyException, UploadManager.CanNotGetGfycatStatusException, UploadManager.CanNotUploadGfycatException, UploadManager.FailedToCreateGfycatException, UploadManager.GfycatWasDeletedBeforeCompletionException {
        return this.createGfycat(creationParams, inputStream, DUMMY_LISTENER);
    }

    @Override
    public Gfycat createGfycat(CreateGfycatRequest creationParams, InputStream inputStream, UploadListener listener) throws UploadManager.CanNotCreateKeyException, UploadManager.CanNotGetGfycatStatusException, UploadManager.CanNotUploadGfycatException, UploadManager.FailedToCreateGfycatException, UploadManager.GfycatWasDeletedBeforeCompletionException {
        listener.onUpdate(UploadListener.Stage.REQUESTING_KEY, -1);
        String gfyName = this.requestCreationKey(creationParams);
        this.upload(gfyName, inputStream, listener);
        listener.onUpdate(UploadListener.Stage.SERVER_PROCESSING, -1);
        return this.waitUntilReady(gfyName);
    }

    @Override
    public Gfycat getGfycatIfReady(String gfyName) {
        try {
            Gfycat gfycat = this.getGfycatByName.getGfycat(gfyName);
            if (gfycat != null) {
                return gfycat;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean isGfycatReady(String gfyName) {
        return this.getGfycatIfReady(gfyName) != null;
    }

    private boolean isCreationEnded(String gfyName, CreationStatus creationStatus) {
        if (creationStatus != null && STATUS_COMPLETE.equals(creationStatus.getTask())) {
            if (!Utils.equals((Object)gfyName, (Object)creationStatus.getGfyname())) {
                Assertions.fail((Throwable)new IllegalStateException("Expected(" + gfyName + ") and actual(" + creationStatus.getGfyname() + ") gfyNames differ."));
                throw new UploadManager.InternalCreationException();
            }
            return true;
        }
        return false;
    }

    public static interface GetGfycatByName {
        public Gfycat getGfycat(String var1) throws IOException;
    }
}

