/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.contentmanagement;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.gfycat.common.utils.Logging;
import com.gfycat.common.utils.Sugar;
import com.gfycat.core.contentmanagement.UserOwnedContentManager;
import com.gfycat.core.creation.CreationAPI;
import com.gfycat.core.creation.pojo.UpdateGfycat;
import com.gfycat.core.db.GfycatFeedCache;
import com.gfycat.core.gfycatapi.GfycatAPI;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import com.gfycat.core.gfycatapi.pojo.NSFWUpdateRequest;
import com.gfycat.core.gfycatapi.pojo.PublishedUpdateRequest;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import retrofit2.Response;

public class UserOwnedContentManagerImpl
implements UserOwnedContentManager {
    private static final String LOG_TAG = "UserOwnedContentManagerImpl";
    private final GfycatAPI gfycatApi;
    private final CreationAPI creationApi;
    private final GfycatFeedCache gfycatFeedCache;
    private final Handler handler;

    public UserOwnedContentManagerImpl(GfycatAPI gfycatApi, CreationAPI creationApi, GfycatFeedCache gfycatFeedCache) {
        this.gfycatApi = gfycatApi;
        this.creationApi = creationApi;
        this.gfycatFeedCache = gfycatFeedCache;
        this.handler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void delete(Gfycat gfycat) {
        Runnable deleteLocally = () -> AsyncTask.execute(() -> this.gfycatFeedCache.markDeleted(gfycat, true));
        Runnable undoDeleteLocally = () -> AsyncTask.execute(() -> this.gfycatFeedCache.markDeleted(gfycat, false));
        Runnable networkOperation = () -> this.gfycatApi.delete(gfycat.getGfyId()).subscribeOn(Schedulers.io()).subscribe(responseBodyResponse -> {
            if (!responseBodyResponse.isSuccessful() && responseBodyResponse.code() != 404) {
                undoDeleteLocally.run();
            }
        }, throwable -> undoDeleteLocally.run());
        networkOperation.run();
        deleteLocally.run();
    }

    public void markPublishedLocally(String gfyId, boolean published) {
        Sugar.doIfNotNull((Object)this.gfycatFeedCache.getGfycat(gfyId), gfycat -> this.gfycatFeedCache.markPublished((Gfycat)gfycat, published));
    }

    private Runnable performPublished(Gfycat gfycat, long undoDuration, boolean publish) {
        Runnable privateLocally = () -> AsyncTask.execute(() -> this.gfycatFeedCache.markPublished(gfycat, publish));
        Runnable undoPrivateLocally = () -> AsyncTask.execute(() -> this.gfycatFeedCache.markPublished(gfycat, !publish));
        Runnable networkOperation = () -> this.gfycatApi.updatePublishedState(gfycat.getGfyId(), PublishedUpdateRequest.makePublic(publish)).subscribeOn(Schedulers.io()).subscribe(responseBodyResponse -> {}, throwable -> Logging.d((String)LOG_TAG, (Object[])new Object[]{"makePrivate error", throwable}));
        return this.perform(undoDuration, privateLocally, undoPrivateLocally, networkOperation);
    }

    @Override
    public Runnable makePrivate(Gfycat gfycat, long undoDuration) {
        return this.performPublished(gfycat, undoDuration, false);
    }

    @Override
    public Runnable makePublic(Gfycat gfycat, long undoDuration) {
        return this.performPublished(gfycat, undoDuration, true);
    }

    private Runnable performNSFW(Gfycat gfycat, long undoDuration, boolean nsfw) {
        Runnable privateLocally = () -> AsyncTask.execute(() -> this.gfycatFeedCache.markNsfw(gfycat, nsfw));
        Runnable undoPrivateLocally = () -> AsyncTask.execute(() -> this.gfycatFeedCache.markNsfw(gfycat, !nsfw));
        Runnable networkOperation = () -> this.gfycatApi.updateNSFW(gfycat.getGfyId(), NSFWUpdateRequest.notSafeForWork(nsfw)).subscribeOn(Schedulers.io()).subscribe(responseBodyResponse -> {}, throwable -> Logging.d((String)LOG_TAG, (Object[])new Object[]{"makePrivate error", throwable}));
        return this.perform(undoDuration, privateLocally, undoPrivateLocally, networkOperation);
    }

    @Override
    public Runnable suitableForAllAges(Gfycat gfycat, long undoDuration) {
        return this.performNSFW(gfycat, undoDuration, false);
    }

    @Override
    public Runnable markAs18Only(Gfycat gfycat, long undoDuration) {
        return this.performNSFW(gfycat, undoDuration, true);
    }

    @Override
    public Single<Boolean> updatePublishState(Gfycat gfycat, boolean published) {
        return this.creationApi.updatePublishState(gfycat.getGfyId(), UpdateGfycat.publishState(published)).map(Response::isSuccessful).singleOrError();
    }

    @Override
    public Single<Boolean> updateDescription(Gfycat gfycat, String description) {
        return this.creationApi.updateDescription(gfycat.getGfyId(), UpdateGfycat.description(description)).map(Response::isSuccessful).singleOrError();
    }

    @Override
    public Single<Boolean> updateTitle(Gfycat gfycat, String title) {
        return this.creationApi.updateTitle(gfycat.getGfyId(), UpdateGfycat.title(title)).map(Response::isSuccessful).singleOrError();
    }

    @Override
    public Single<Boolean> addTags(Gfycat gfycat, List<String> tags) {
        return this.creationApi.addTags(gfycat.getGfyId(), UpdateGfycat.tags(tags)).map(Response::isSuccessful).singleOrError();
    }

    private Runnable perform(long undoTime, Runnable localComplete, Runnable localUndo, Runnable remoteComplete) {
        this.handler.postDelayed(remoteComplete, undoTime);
        localComplete.run();
        return () -> {
            this.handler.removeCallbacks(remoteComplete);
            localUndo.run();
        };
    }
}

