/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.contentmanagement;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.gfycat.common.ChainedException;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.gfycat.core.contentmanagement.NSFWContentManager;
import com.gfycat.core.db.GfycatFeedCache;
import com.gfycat.core.gfycatapi.GfycatAPI;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import io.reactivex.schedulers.Schedulers;

public class NSFWContentManagerImpl
implements NSFWContentManager {
    private static final String LOG_TAG = "NSFWContentManagerImpl";
    private final Handler handler;
    private final GfycatAPI api;
    private final GfycatFeedCache gfycatFeedCache;

    public NSFWContentManagerImpl(GfycatAPI gfycatAPI, GfycatFeedCache gfycatFeedCache) {
        this.api = gfycatAPI;
        this.gfycatFeedCache = gfycatFeedCache;
        this.handler = new Handler(Looper.getMainLooper());
    }

    @Override
    public Runnable reportItem(Gfycat gfcycat) {
        Logging.d((String)LOG_TAG, (String)("reportItem(" + gfcycat.getGfyId() + ")"));
        this.gfycatFeedCache.blockItem(gfcycat, true);
        this.api.blockContent(gfcycat.getGfyId()).subscribeOn(Schedulers.io()).subscribe(response -> Assertions.assertTrue((boolean)response.isSuccessful(), () -> new IllegalStateException("reportItem was not successful")), throwable -> Assertions.fail((Throwable)new ChainedException(throwable)));
        return new UndoBlockItem(gfcycat);
    }

    @Override
    public Runnable reportUser(Gfycat gfycat, long undoPossibilityTimeMs) {
        String username = gfycat.getUserName();
        Logging.d((String)LOG_TAG, (String)("reportUser(" + username + ")"));
        if (this.isAnonymous(username)) {
            Logging.d((String)LOG_TAG, (String)("reportUser(" + username + ") from anonymous user, let's just block content."));
            return this.reportItem(gfycat);
        }
        this.gfycatFeedCache.blockUser(gfycat.getUserName(), true);
        Runnable blockRemoteBlockUser = () -> this.api.blockUser(gfycat.getUserName()).subscribeOn(Schedulers.io()).subscribe(response -> Assertions.assertTrue((boolean)response.isSuccessful(), () -> new IllegalStateException("blocking user was not successful")), throwable -> Assertions.fail((Throwable)new ChainedException(throwable)));
        this.handler.postDelayed(blockRemoteBlockUser, undoPossibilityTimeMs);
        return new UndoBlockUser(gfycat.getUserName(), () -> this.handler.removeCallbacks(blockRemoteBlockUser));
    }

    private boolean isAnonymous(String username) {
        return username == null || TextUtils.isEmpty((CharSequence)username) || "anonymous".equals(username);
    }

    private class UndoBlockItem
    implements Runnable {
        private final Gfycat gfycat;

        private UndoBlockItem(Gfycat gfycat) {
            this.gfycat = gfycat;
        }

        @Override
        public void run() {
            Logging.d((String)NSFWContentManagerImpl.LOG_TAG, (String)(" UndoBlockItem::run(" + this.gfycat + ")"));
            NSFWContentManagerImpl.this.gfycatFeedCache.blockItem(this.gfycat, false);
        }
    }

    private class UndoBlockUser
    implements Runnable {
        private final String username;
        private final Runnable callback;

        public UndoBlockUser(String username, Runnable callback) {
            this.username = username;
            this.callback = callback;
        }

        @Override
        public void run() {
            Logging.d((String)NSFWContentManagerImpl.LOG_TAG, (String)(" UndoBlockUser::run(" + this.username + ")"));
            NSFWContentManagerImpl.this.gfycatFeedCache.blockUser(this.username, false);
            this.callback.run();
        }
    }
}

