/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.bi.impression;

import android.content.Context;
import com.gfycat.common.BILogcat;
import com.gfycat.common.utils.Utils;
import com.gfycat.core.GfyPrivate;
import com.gfycat.core.GfycatApplicationInfo;
import com.gfycat.core.bi.CommonKeys;
import com.gfycat.core.bi.impression.ImpressionInfo;
import com.gfycat.core.bi.impression.PixelAPI;
import java.util.Map;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class GfycatImpression {
    private final String LOG_TAG = "GfycatImpression";
    private final String deviceID;
    private final String appId;
    private final String clientId;
    private final String versionName;
    private final PixelAPI pixelApi;
    private static GfycatImpression instance;

    public static synchronized void initialize(Context context, GfycatApplicationInfo gfycatApplicationInfo) {
        if (instance != null) {
            throw new IllegalStateException("Initialize called twice.");
        }
        instance = new GfycatImpression(context, gfycatApplicationInfo);
    }

    private static GfycatImpression get() {
        if (instance == null) {
            throw new IllegalStateException("Initialize not called.");
        }
        return instance;
    }

    private GfycatImpression(Context context, GfycatApplicationInfo gfycatApplicationInfo) {
        this.deviceID = Utils.getDeviceID((Context)context);
        this.appId = Utils.getApplicationId((Context)context);
        this.clientId = gfycatApplicationInfo.clientId;
        this.versionName = Utils.getVersionName((Context)context);
        this.pixelApi = this.buildPixelApi();
    }

    private PixelAPI buildPixelApi() {
        return (PixelAPI)new Retrofit.Builder().client(new OkHttpClient()).baseUrl("https://px." + GfyPrivate.get().getDomainName()).build().create(PixelAPI.class);
    }

    public static void logImpression(ImpressionInfo impressionInfo) {
        impressionInfo.ensureInfoSetCorrectly();
        GfycatImpression.get().track(impressionInfo.asParams());
    }

    private void track(Map<String, String> params) {
        this.addPixelParams(params);
        BILogcat.log((String)"GfycatImpression", (String)"impression", params);
        this.pixelApi.pixelCall(params, PixelAPI.DUMMY_BODY).enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
            }

            public void onFailure(Call<Void> call, Throwable t) {
            }
        });
    }

    private void addPixelParams(Map<String, String> params) {
        params.put(CommonKeys.APP_ID_KEY, this.appId);
        params.put(CommonKeys.CLIENT_ID_KEY, this.clientId);
        params.put(CommonKeys.VER_KEY, this.versionName);
        params.put(CommonKeys.USER_ID_KEY, this.deviceID);
    }

    static void deInitialize() {
        instance = null;
    }
}

