/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.bi.analytics;

import android.content.Context;
import com.gfycat.common.BILogcat;
import com.gfycat.common.utils.Utils;
import com.gfycat.core.GfyPrivate;
import com.gfycat.core.GfycatApplicationInfo;
import com.gfycat.core.bi.CommonKeys;
import com.gfycat.core.bi.analytics.BIEngine;
import com.gfycat.core.bi.analytics.MetricsAPI;
import java.util.Map;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class MetricsEngine
implements BIEngine {
    private final String LOG_TAG = "MetricsEngine";
    private static String EVENT_KEY = "event";
    private final String deviceID;
    private final String appId;
    private final String clientId;
    private final String versionName;
    private final MetricsAPI metricsApi;

    public MetricsEngine(Context context, GfycatApplicationInfo gfycatApplicationInfo) {
        this.deviceID = Utils.getDeviceID((Context)context);
        this.appId = Utils.getApplicationId((Context)context);
        this.clientId = gfycatApplicationInfo.clientId;
        this.versionName = Utils.getVersionName((Context)context);
        this.metricsApi = MetricsEngine.buildMetricsApi();
    }

    @Override
    public void track(String eventName, Map<String, String> params) {
        this.addMetricsParams(eventName, params);
        BILogcat.log((String)"MetricsEngine", (String)eventName, params);
        this.metricsApi.metricsCall(params, MetricsAPI.DUMMY_BODY).enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
            }

            public void onFailure(Call<Void> call, Throwable t) {
            }
        });
    }

    private static MetricsAPI buildMetricsApi() {
        return (MetricsAPI)new Retrofit.Builder().client(new OkHttpClient()).baseUrl("https://metrics." + GfyPrivate.get().getDomainName() + "/").build().create(MetricsAPI.class);
    }

    private void addMetricsParams(String eventName, Map<String, String> params) {
        params.put(EVENT_KEY, eventName);
        params.put(CommonKeys.APP_ID_KEY, this.appId);
        params.put(CommonKeys.CLIENT_ID_KEY, this.clientId);
        params.put(CommonKeys.VER_KEY, this.versionName);
        params.put(CommonKeys.USER_ID_KEY, this.deviceID);
    }
}

