/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.bi.analytics;

import com.gfycat.common.utils.Logging;
import com.gfycat.core.bi.analytics.BILogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public class GroupLogger<T extends BILogger> {
    private static final String LOG_TAG = "GroupLogger";
    private List<T> loggers = new ArrayList<T>();
    private final InvocationHandler invocationHandler = new BILoggerInvocationHandler();
    private final T proxyLogger;

    public GroupLogger(Class<T> loggerClass) {
        this.proxyLogger = (BILogger)loggerClass.cast(Proxy.newProxyInstance(loggerClass.getClassLoader(), new Class[]{loggerClass}, this.invocationHandler));
    }

    public void add(T logger) {
        this.loggers.add(logger);
    }

    public T getProxyLogger() {
        return this.proxyLogger;
    }

    private class BILoggerInvocationHandler
    implements InvocationHandler {
        private BILoggerInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (BILogger logger : GroupLogger.this.loggers) {
                Logging.d((String)GroupLogger.LOG_TAG, (String)(logger.getClass().getSimpleName() + "." + method.getName() + "()"));
                method.invoke((Object)logger, args);
            }
            return null;
        }
    }
}

