/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.authentication.pojo;

import com.gfycat.core.GfycatApplicationInfo;
import com.google.gson.annotations.SerializedName;

public class TokenRequest {
    @SerializedName(value="client_id")
    private final String clientId;
    @SerializedName(value="client_secret")
    private final String clientSecret;
    @SerializedName(value="grant_type")
    private String grantType;
    private String scope;
    private String username;
    private String password;
    @SerializedName(value="refresh_token")
    private String refreshToken;
    private String provider;
    private String token;

    public static TokenRequest applicationTokenRequest(GfycatApplicationInfo gfycatApplicationInfo) {
        TokenRequest request = new TokenRequest(gfycatApplicationInfo);
        request.grantType = "client_credentials";
        return request;
    }

    public static TokenRequest facebookTokenRequest(GfycatApplicationInfo gfycatApplicationInfo, String token) {
        TokenRequest request = new TokenRequest(gfycatApplicationInfo);
        request.grantType = "convert_token";
        request.provider = "facebook";
        request.token = token;
        return request;
    }

    public static TokenRequest userTokenRequest(GfycatApplicationInfo gfycatApplicationInfo, String username, String password) {
        TokenRequest request = new TokenRequest(gfycatApplicationInfo);
        request.grantType = "password";
        request.scope = "basicProfile,publishPost,listPublications,create";
        request.username = username;
        request.password = password;
        return request;
    }

    public static TokenRequest refreshUserTokenRequest(GfycatApplicationInfo gfycatApplicationInfo, String refreshToken) {
        TokenRequest request = new TokenRequest(gfycatApplicationInfo);
        request.grantType = "refresh";
        request.refreshToken = refreshToken;
        return request;
    }

    public TokenRequest(GfycatApplicationInfo gfycatApplicationInfo) {
        this.clientId = gfycatApplicationInfo.clientId;
        this.clientSecret = gfycatApplicationInfo.clientSecret;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getToken() {
        return this.token;
    }
}

