/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.authentication;

import android.content.Context;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.gfycat.common.ChainedException;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.gfycat.common.utils.Utils;
import com.gfycat.core.GfyCore;
import com.gfycat.core.NoAuthAPI;
import com.gfycat.core.authentication.ErrorMessageException;
import com.gfycat.core.authentication.GhostUserPreference;
import com.gfycat.core.authentication.Token;
import com.gfycat.core.authentication.TokenAuthenticator;
import com.gfycat.core.authentication.TypedImageRequestBody;
import com.gfycat.core.authentication.UserAccountManager;
import com.gfycat.core.authentication.UserInfoStorage;
import com.gfycat.core.bi.BIContext;
import com.gfycat.core.bi.analytics.GfycatAnalytics;
import com.gfycat.core.bi.corelogger.CoreLogger;
import com.gfycat.core.gfycatapi.GfycatAPI;
import com.gfycat.core.gfycatapi.pojo.ErrorMessage;
import com.gfycat.core.gfycatapi.pojo.ResetPasswordRequest;
import com.gfycat.core.gfycatapi.pojo.TransferGfycatsRequest;
import com.gfycat.core.gfycatapi.pojo.UpdateUserInfo;
import com.gfycat.core.gfycatapi.pojo.UserInfo;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import retrofit2.HttpException;
import retrofit2.Response;

public class UserAccountManagerImpl
implements UserAccountManager {
    private static final String LOG_TAG = "UserAccountManagerImpl";
    private static final long WAIT_AVATAR_DURATION = 3L;
    private static final long TRIALS_COUNT = 10L;
    private static final String GHOST_USERNAME_PREFIX = "ghost_";
    private static final int USERNAME_SIZE = 20;
    private static final int PASSWORD_SIZE = 20;
    private UserInfoStorage userInfoStorage;
    private final TokenAuthenticator authenticator;
    private final GfycatAPI gfycatAPI;
    private final NoAuthAPI noAuthApi;
    private final Disposable tokenChangeSubscription;
    private final Runnable dropUserRelatedContent;
    private final GhostUserPreference ghostUserPreference;

    public UserAccountManagerImpl(Context context, TokenAuthenticator authenticator, GfycatAPI gfycatAPI, NoAuthAPI noAuthApi, Runnable dropUserRelatedContent) {
        this.authenticator = authenticator;
        this.gfycatAPI = gfycatAPI;
        this.noAuthApi = noAuthApi;
        this.userInfoStorage = new UserInfoStorage(context);
        this.tokenChangeSubscription = authenticator.observeToken().observeOn(Schedulers.io()).subscribe((Consumer)new RefreshAction(), throwable -> Assertions.fail((Throwable)new ChainedException(throwable)));
        this.dropUserRelatedContent = dropUserRelatedContent;
        this.ghostUserPreference = new GhostUserPreference(context);
    }

    public boolean isUserReal() {
        return this.isSignedIn() && !this.ghostUserPreference.isUserGhost();
    }

    public boolean isUserGhost() {
        return this.isSignedIn() && this.ghostUserPreference.isUserGhost();
    }

    @Override
    public Single<String> facebookSignUp(String login, String facebookToken) {
        return this.authenticator.facebookSignUp(login, facebookToken, new TransferGfycatsIfNeeded());
    }

    @Override
    public Completable validateUserEmail() {
        return this.gfycatAPI.verifyUserEmail("").onErrorResumeNext(throwable -> {
            if (throwable instanceof IOException) {
                return Completable.complete();
            }
            if (throwable instanceof HttpException) {
                HttpException httpException = (HttpException)throwable;
                if (httpException.code() == 400) {
                    return Completable.error((Throwable)new ErrorMessageException(new ErrorMessage("EmailNotVerified", "Unable to send verification email.")));
                }
                if (httpException.code() == 404) {
                    return Completable.error((Throwable)new ErrorMessageException(new ErrorMessage("EmailNotVerified", "Unable to send verification email.")));
                }
                Assertions.fail((Throwable)new IllegalStateException("UserAccountManagerImpl Unknown code for observeUserNameAvailability " + httpException.code(), (Throwable)throwable));
                return Completable.complete();
            }
            Assertions.fail((Throwable)new IllegalStateException("UserAccountManagerImpl Class cast in observeUserNameAvailability throwable instanceof " + throwable, (Throwable)throwable));
            return Completable.complete();
        });
    }

    @Override
    public Single<String> facebookSignIn(String facebookToken, String facebookId, String facebookName) {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"facebookSignIn(", facebookId, ", ", facebookName, ")"});
        return this.authenticator.facebookSignIn(facebookToken, new TransferGfycatsIfNeeded()).onErrorResumeNext((Function)new MapFacebookUserNotExistsToCreateUserError()).doOnSuccess(username -> GfycatAnalytics.getLogger(CoreLogger.class).logAccountLoggedIn(new BIContext("facebook"), facebookName, "", facebookId)).doOnSuccess(username -> this.ghostUserPreference.setUserReal());
    }

    @Override
    public Single<String> signIn(String accountOrEmail, String password) {
        return this.authenticator.signIn(accountOrEmail, password, new TransferGfycatsIfNeeded()).doOnSuccess(username -> GfycatAnalytics.getLogger(CoreLogger.class).logAccountLoggedIn(new BIContext("email"), (String)username, accountOrEmail, "")).doOnSuccess(s -> this.ghostUserPreference.setUserReal());
    }

    public Completable signUpGhost() {
        String username;
        Throwable availabilityException;
        if (this.isSignedIn()) {
            throw new IllegalStateException("Can not create ghost account with already signed user.");
        }
        String password = Utils.randomString((int)20);
        int tryCount = 0;
        do {
            username = GHOST_USERNAME_PREFIX + Utils.randomString((int)(20 - GHOST_USERNAME_PREFIX.length()));
        } while ((availabilityException = GfyCore.getUserAccountManager().observeUserNameAvailability(username).blockingGet()) != null && tryCount++ < 5);
        return this.authenticator.signUp(username, password, new TransferGfycatsIfNeeded()).doOnSuccess(localUsername -> GfycatAnalytics.getLogger(CoreLogger.class).logAccountCreated(new BIContext("ghost"), (String)localUsername, "", "")).flatMap(this::waitForUserInfoUpdate).ignoreElement().doOnComplete(this.ghostUserPreference::setUserGhost);
    }

    private Single<String> waitForUserInfoUpdate(String username) {
        return this.observe().filter(userInfo -> userInfo != null && username.equals(userInfo.getUserid())).firstOrError().map(UserInfo::getUserid);
    }

    @Override
    public Single<String> signUp(String username, String password) {
        return this.authenticator.signUp(username, password, new TransferGfycatsIfNeeded()).doOnSuccess(s -> GfycatAnalytics.getLogger(CoreLogger.class).logAccountCreated(new BIContext("ghost"), username, "", "")).doOnSuccess(s -> this.ghostUserPreference.setUserReal());
    }

    @Override
    public Single<String> signUp(String email, String username, String password) {
        return this.authenticator.signUp(username, email, password, new TransferGfycatsIfNeeded()).doOnSuccess(s -> GfycatAnalytics.getLogger(CoreLogger.class).logAccountCreated(new BIContext("email"), username, email, "")).doOnSuccess(s -> this.ghostUserPreference.setUserReal());
    }

    @Override
    public Completable resetPassword(String email) {
        return this.gfycatAPI.resetPassword(new ResetPasswordRequest(email)).onErrorResumeNext(throwable -> Completable.error((Throwable)ErrorMessageException.fromRawThrowable(throwable)));
    }

    @Override
    public void signOut() {
        Logging.c((String)LOG_TAG, (Object[])new Object[]{"signOut()"});
        this.authenticator.signOut();
    }

    @Override
    public boolean isSignedIn() {
        return this.userInfoStorage.get() != UserInfoStorage.NO_USER;
    }

    @Override
    public Completable observeUserNameAvailability(String username) {
        return this.gfycatAPI.checkAvailability(username).flatMapCompletable(response -> {
            if (response.code() == 204) {
                return Completable.error((Throwable)new ErrorMessageException(new ErrorMessage("UsernameUnavailable", "Username is unavailable.")));
            }
            if (response.code() == 422) {
                return Completable.error((Throwable)new ErrorMessageException(new ErrorMessage("InvalidUsername", "The username was invalid.")));
            }
            if (response.code() == 404) {
                return Completable.complete();
            }
            Logging.c((String)LOG_TAG, (Object[])new Object[]{"unknown error code for response", new RuntimeException()});
            return Completable.complete();
        });
    }

    @Override
    public UserInfo getUserInfo() {
        return (UserInfo)this.userInfoStorage.get();
    }

    @Override
    public Observable<UserInfo> observe() {
        return this.userInfoStorage.observe();
    }

    @Override
    public Completable updateUserProfile(UpdateUserInfo body) {
        return this.gfycatAPI.updateUserProfile(body).andThen((CompletableSource)this.refreshUserProfile()).onErrorResumeNext(throwable -> Completable.error((Throwable)new ErrorMessageException(new ErrorMessage("-1", throwable.getMessage())))).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    @Override
    public Completable uploadUserAvatar(InputStream is) {
        return this.gfycatAPI.getUploadURL().flatMap(responseBodyResponse -> {
            String destinationUrl = "";
            try {
                destinationUrl = ((ResponseBody)responseBodyResponse.body()).string();
                destinationUrl = destinationUrl.replace("\\", "");
                destinationUrl = destinationUrl.replace("\"", "");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!URLUtil.isValidUrl((String)destinationUrl) || !destinationUrl.contains("/")) {
                return Single.error((Throwable)new Throwable("Invalid upload URL!"));
            }
            String ticket = destinationUrl.substring(destinationUrl.lastIndexOf(47) + 1);
            TypedImageRequestBody requestBody = new TypedImageRequestBody(MediaType.parse((String)"multipart/form-data"), is);
            return this.noAuthApi.uploadAvatarImage(destinationUrl, requestBody).flatMap(response -> this.waitAvatarChanged(0L, ticket, 0)).ignoreElements().andThen((CompletableSource)this.refreshUserProfile()).onErrorResumeNext(throwable -> Completable.error((Throwable)new ErrorMessageException(new ErrorMessage("-1", throwable.getMessage())))).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).toSingle(() -> "");
        }).toCompletable().onErrorResumeNext(throwable -> Completable.error((Throwable)new ErrorMessageException(new ErrorMessage("-1", throwable.getMessage())))).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Observable<Response<ResponseBody>> waitAvatarChanged(long delay, String ticket, int count) {
        return Observable.timer((long)delay, (TimeUnit)TimeUnit.SECONDS).flatMap(aLong -> this.gfycatAPI.getAvatarStatus(ticket).flatMap(response -> {
            String result = "";
            try {
                result = ((ResponseBody)response.body()).string();
            }
            catch (IOException ex) {
                return Observable.error((Throwable)ex);
            }
            if (response.isSuccessful() && result.equalsIgnoreCase("\"succeeded\"")) {
                return Observable.just((Object)response);
            }
            if (!response.isSuccessful()) {
                return Observable.error((Throwable)new Throwable(response.message()));
            }
            if ((long)count >= 10L) {
                return Observable.error((Throwable)new Throwable("Timeout exception."));
            }
            return this.waitAvatarChanged(3L, ticket, count + 1);
        }));
    }

    private Completable refreshUserProfile() {
        return this.gfycatAPI.getMyInfo().doOnNext(userInfo -> this.userInfoStorage.putSync(userInfo)).ignoreElements();
    }

    private void dropUserContent() {
        Logging.d((String)LOG_TAG, (String)"dropUserContent()");
        if (this.dropUserRelatedContent != null) {
            this.dropUserRelatedContent.run();
        }
    }

    public void release() {
        if (this.tokenChangeSubscription != null) {
            this.tokenChangeSubscription.dispose();
        }
    }

    private static void collectTransferIssueDetails(Token prev, Token next, Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        sb.append("from:[").append(prev.getUserid()).append(" ").append(prev.getAccessToken()).append("]");
        sb.append("to:[").append(next.getUserid()).append(" ").append(next.getAccessToken()).append("]");
        if (throwable instanceof HttpException) {
            HttpException httpException = (HttpException)throwable;
            sb.append("code:").append(httpException.code()).append(" ");
            sb.append("message:").append(httpException.message()).append(" ");
            try {
                sb.append("body:").append(httpException.response().errorBody().string());
            }
            catch (IOException e) {
                sb.append("[IOException] while reading body");
            }
        }
        Assertions.fail((Throwable)new ChainedException(sb.toString(), throwable));
    }

    private class TransferGfycatsIfNeeded
    implements BiConsumer<Token, Token> {
        private TransferGfycatsIfNeeded() {
        }

        public void accept(Token prev, Token next) {
            if (prev != null && !TextUtils.isEmpty((CharSequence)prev.getUserid()) && UserAccountManagerImpl.this.isUserGhost()) {
                try {
                    Logging.d((String)UserAccountManagerImpl.LOG_TAG, (Object[])new Object[]{"TransferGfycatsIfNeeded from ", prev.getUserid(), " to ", next.getUserid()});
                    UserAccountManagerImpl.this.gfycatAPI.transferGfycats(next.getUserid(), new TransferGfycatsRequest(prev.getAccessToken(), next.getAccessToken())).blockingAwait();
                }
                catch (Throwable throwable) {
                    UserAccountManagerImpl.collectTransferIssueDetails(prev, next, throwable);
                }
            }
        }
    }

    public static class FacebookCreateUserException
    extends Throwable {
        public FacebookCreateUserException(String description) {
            super(description);
        }
    }

    public static class FacebookSignInException
    extends Throwable {
    }

    private class MapFacebookUserNotExistsToCreateUserError
    implements Function<Throwable, Single<String>> {
        private MapFacebookUserNotExistsToCreateUserError() {
        }

        public Single<String> apply(Throwable throwable) {
            if (throwable instanceof ErrorMessageException) {
                ErrorMessageException authException = (ErrorMessageException)throwable;
                if ("UserNotExists".equals(authException.getErrorMessage().getCode())) {
                    return Single.error((Throwable)new FacebookCreateUserException(authException.getErrorMessage().getDescription()));
                }
                return Single.error((Throwable)new FacebookSignInException());
            }
            return Single.error((Throwable)throwable);
        }
    }

    private class RefreshAction
    implements Consumer<Token> {
        private RefreshAction() {
        }

        public void accept(Token token) {
            UserInfo userInfo = (UserInfo)UserAccountManagerImpl.this.userInfoStorage.get();
            Logging.d((String)UserAccountManagerImpl.LOG_TAG, (Object[])new Object[]{"::RefreshAction called with token = ", token, " userInfo = ", userInfo});
            if (token == null || TextUtils.isEmpty((CharSequence)token.getUserid())) {
                if (userInfo != UserInfoStorage.NO_USER) {
                    Logging.c((String)UserAccountManagerImpl.LOG_TAG, (Object[])new Object[]{"user logged out, drop it's data"});
                    UserAccountManagerImpl.this.dropUserContent();
                    Logging.setUserId(null);
                    UserAccountManagerImpl.this.userInfoStorage.putSync(UserInfoStorage.NO_USER);
                    UserAccountManagerImpl.this.ghostUserPreference.setUserGhost();
                } else {
                    Logging.d((String)UserAccountManagerImpl.LOG_TAG, (String)"application token refresh happens");
                }
            } else {
                String newUserId = token.getUserid();
                Logging.setUserId((String)newUserId);
                if (userInfo == UserInfoStorage.NO_USER) {
                    Logging.c((String)UserAccountManagerImpl.LOG_TAG, (Object[])new Object[]{"new user logged in"});
                    UserAccountManagerImpl.this.userInfoStorage.putSync(UserInfo.from(newUserId));
                }
                if (userInfo != UserInfoStorage.NO_USER && !userInfo.getUserid().equals(newUserId)) {
                    Logging.c((String)UserAccountManagerImpl.LOG_TAG, (Object[])new Object[]{"another user logged in, drop db"});
                    UserAccountManagerImpl.this.dropUserContent();
                    UserAccountManagerImpl.this.userInfoStorage.putSync(UserInfo.from(newUserId));
                }
                UserAccountManagerImpl.this.gfycatAPI.getMyInfo().subscribe(updatedUserInfo -> {
                    Logging.d((String)UserAccountManagerImpl.LOG_TAG, (String)("successfully updated userInfo = " + updatedUserInfo));
                    UserAccountManagerImpl.this.userInfoStorage.putSync(updatedUserInfo);
                }, throwable -> Logging.e((String)UserAccountManagerImpl.LOG_TAG, (Object[])new Object[]{"onErrorHappens in RefreshAction gfycatAPI.getMyInfo()", throwable}));
            }
        }
    }
}

