/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.authentication;

import android.support.annotation.Nullable;
import com.gfycat.core.authentication.UserAccountManager;
import com.gfycat.core.gfycatapi.pojo.UpdateUserInfo;
import com.gfycat.core.gfycatapi.pojo.UserInfo;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.subjects.ReplaySubject;
import java.io.InputStream;

public class UserAccountManagerAsyncWrapper
implements UserAccountManager {
    private ReplaySubject<UserAccountManager> subject = ReplaySubject.create();

    public void init(UserAccountManager userAccountManager) {
        if (this.subject.hasComplete()) {
            return;
        }
        this.subject.onNext((Object)userAccountManager);
        this.subject.onComplete();
    }

    @Override
    public UserInfo getUserInfo() {
        UserAccountManager userAccountManager = (UserAccountManager)this.subject.getValue();
        return userAccountManager != null ? userAccountManager.getUserInfo() : null;
    }

    @Override
    public Observable<UserInfo> observe() {
        return this.subject.flatMap(UserAccountManager::observe);
    }

    @Override
    public boolean isSignedIn() {
        UserAccountManager userAccountManager = (UserAccountManager)this.subject.getValue();
        return userAccountManager != null && userAccountManager.isSignedIn();
    }

    @Override
    public Completable observeUserNameAvailability(String username) {
        return this.subject.flatMap(manager -> manager.observeUserNameAvailability(username).toObservable()).ignoreElements();
    }

    @Override
    public Completable resetPassword(String email) {
        return this.subject.flatMap(manager -> manager.resetPassword(email).toObservable()).ignoreElements();
    }

    @Override
    public Single<String> signIn(String accountOrEmail, String password) {
        return this.subject.singleOrError().flatMap(manager -> manager.signIn(accountOrEmail, password));
    }

    @Override
    public Single<String> signUp(String username, String password) {
        return this.subject.singleOrError().flatMap(manager -> manager.signUp(username, password));
    }

    @Override
    public Single<String> signUp(String email, String username, String password) {
        return this.subject.singleOrError().flatMap(manager -> manager.signUp(email, username, password));
    }

    @Override
    public Single<String> facebookSignIn(String facebookToken, @Nullable String facebookId, @Nullable String facebookName) {
        return this.subject.singleOrError().flatMap(manager -> manager.facebookSignIn(facebookToken, facebookId, facebookName));
    }

    @Override
    public Single<String> facebookSignUp(String login, String facebookToken) {
        return this.subject.singleOrError().flatMap(manager -> manager.facebookSignUp(login, facebookToken));
    }

    @Override
    public void signOut() {
        UserAccountManager userAccountManager = (UserAccountManager)this.subject.getValue();
        if (userAccountManager != null) {
            userAccountManager.signOut();
        }
    }

    @Override
    public Completable validateUserEmail() {
        return this.subject.flatMap(userAccountManager -> userAccountManager.validateUserEmail().toObservable()).ignoreElements();
    }

    @Override
    public Completable updateUserProfile(UpdateUserInfo body) {
        return this.subject.flatMap(manager -> manager.updateUserProfile(body).toObservable()).ignoreElements();
    }

    @Override
    public Completable uploadUserAvatar(InputStream is) {
        return this.subject.flatMap(manager -> manager.uploadUserAvatar(is).toObservable()).ignoreElements();
    }
}

