/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.authentication;

import android.content.Context;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.gfycat.core.GfycatApplicationInfo;
import com.gfycat.core.authentication.AuthenticationAPI;
import com.gfycat.core.authentication.ErrorMessageException;
import com.gfycat.core.authentication.SignUpAPI;
import com.gfycat.core.authentication.Token;
import com.gfycat.core.authentication.TokenRenewer;
import com.gfycat.core.authentication.TokenRenewerImpl;
import com.gfycat.core.authentication.TokenStorage;
import com.gfycat.core.authentication.pojo.AuthenticationToken;
import com.gfycat.core.authentication.pojo.SignUpRequest;
import com.gfycat.core.authentication.pojo.TokenRequest;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class TokenAuthenticator
implements Authenticator,
Interceptor {
    private static final String LOG_TAG = "TokenAuthenticator";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final int MAX_AUTHENTIFICATION_TRIES = 3;
    private final AtomicBoolean needRenewToken = new AtomicBoolean(false);
    private GfycatApplicationInfo gfycatApplicationInfo;
    private final AuthenticationAPI authenticationApi;
    private final TokenRenewer tokenRenewer = new TokenRenewerImpl();
    private final TokenStorage tokenStorage;
    private volatile Token lastToken = Token.NO_TOKEN;
    private SignUpAPI signUpAPI;

    public TokenAuthenticator(Context context, GfycatApplicationInfo gfycatApplicationInfo, AuthenticationAPI authenticationApi) {
        this.tokenStorage = new TokenStorage(context);
        this.authenticationApi = authenticationApi;
        this.gfycatApplicationInfo = gfycatApplicationInfo;
        this.lastToken = (Token)this.tokenStorage.get();
    }

    public Request authenticate(Route route, Response response) throws IOException {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"::authenticate(", response.request().url().toString(), ") ", TokenAuthenticator.responseCount(response)});
        if (TokenAuthenticator.responseCount(response) > 3) {
            Logging.c((String)LOG_TAG, (Object[])new Object[]{"Failed to authenticate url: " + response.request().url().toString()});
            this.broadcastAuthenticationProblems();
            return null;
        }
        if (this.reNewToken()) {
            return response.request().newBuilder().removeHeader(AUTHORIZATION_HEADER).addHeader(AUTHORIZATION_HEADER, this.bearer(this.lastToken.getAccessToken())).build();
        }
        return null;
    }

    private String bearer(String accessToken) {
        return "Bearer " + accessToken;
    }

    private boolean isValid(Token token) {
        return token != null && token.getError() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean reNewToken() {
        this.needRenewToken.set(true);
        TokenAuthenticator tokenAuthenticator = this;
        synchronized (tokenAuthenticator) {
            if (!this.needRenewToken.get()) {
                Logging.d((String)LOG_TAG, (String)"Other thread updated token while we was waiting synchronization.");
                return true;
            }
            try {
                retrofit2.Response<AuthenticationToken> tokenReponse = this.getNewToken();
                if (tokenReponse.isSuccessful()) {
                    boolean result = this.changeToken((Token)tokenReponse.body());
                    if (!result) {
                        this.signOut();
                    }
                    boolean bl = result;
                    return bl;
                }
                this.signOut();
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                this.signOut();
                boolean bl = false;
                return bl;
            }
            finally {
                this.needRenewToken.set(false);
            }
        }
    }

    private synchronized boolean changeToken(Token token) {
        Assertions.assertNull((Object)token.getError(), () -> new Exception("token.getError() = " + token.getError()));
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"changeToken(", token, ") from: ", this.lastToken});
        if (this.isValid(token)) {
            this.lastToken = token;
            this.tokenStorage.putSync(token);
            return true;
        }
        return false;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"::intercept(", chain.request().url().toString(), ") lastToken = ", this.lastToken});
        Request request = chain.request();
        if (Token.NO_TOKEN.equals(this.lastToken)) {
            this.reNewToken();
        }
        if (!Token.NO_TOKEN.equals(this.lastToken)) {
            request = request.newBuilder().addHeader(AUTHORIZATION_HEADER, this.bearer(this.lastToken.getAccessToken())).build();
        }
        return chain.proceed(request);
    }

    private static int responseCount(Response response) {
        int result = 1;
        while ((response = response.priorResponse()) != null) {
            ++result;
        }
        return result;
    }

    private void broadcastAuthenticationProblems() {
        Logging.d((String)LOG_TAG, (String)"::broadcastAuthenticationProblems()");
        this.tokenStorage.putSync(Token.NO_TOKEN);
    }

    private retrofit2.Response<AuthenticationToken> getNewToken() throws IOException {
        Assertions.assertNotUIThread(IllegalAccessException::new);
        Logging.d((String)LOG_TAG, (Object[])new Object[]{"getNewToken() called with lastToken = ", this.lastToken});
        return this.tokenRenewer.reNew(this.gfycatApplicationInfo, this.authenticationApi, this.lastToken);
    }

    public Single<String> facebookSignUp(String login, String facebookToken, BiConsumer<Token, Token> onTokenChange) {
        Logging.d((String)LOG_TAG, (String)"facebookSignUp(...) with facebook token");
        Assertions.assertNotNull((Object)this.signUpAPI, () -> new NullPointerException("signUpAPI was not set."));
        return this.authenticate(this.signUpAPI.signUp(SignUpRequest.signUpWithFacebook(login, facebookToken)), onTokenChange);
    }

    public Single<String> signUp(String login, String email, String password, BiConsumer<Token, Token> onTokenChange) {
        Logging.d((String)LOG_TAG, (String)"signUp(...) with password");
        Assertions.assertNotNull((Object)this.signUpAPI, () -> new NullPointerException("signUpAPI was not set."));
        return this.authenticate(this.signUpAPI.signUp(SignUpRequest.signUpWithEmailAndPassword(login, email, password)), onTokenChange);
    }

    public Single<String> signUp(String login, String password, BiConsumer<Token, Token> onTokenChange) {
        Logging.d((String)LOG_TAG, (String)"signUp(...) with password");
        Assertions.assertNotNull((Object)this.signUpAPI, () -> new NullPointerException("signUpAPI was not set."));
        return this.authenticate(this.signUpAPI.signUp(SignUpRequest.signUpWithPassword(login, password)), onTokenChange);
    }

    public Single<String> signIn(String login, String password, BiConsumer<Token, Token> onTokenChange) {
        Logging.d((String)LOG_TAG, (String)"signIn(...)");
        return this.authenticate(this.authenticationApi.requestToken(TokenRequest.userTokenRequest(this.gfycatApplicationInfo, login, password)), onTokenChange);
    }

    public Single<String> facebookSignIn(String token, BiConsumer<Token, Token> onTokenChange) {
        Logging.d((String)LOG_TAG, (String)"signIn(...)");
        return this.authenticate(this.authenticationApi.requestToken(TokenRequest.facebookTokenRequest(this.gfycatApplicationInfo, token)), onTokenChange);
    }

    private Single<String> authenticate(Single<AuthenticationToken> single, BiConsumer<Token, Token> onTokenChange) {
        TokenChangeHelper helper = new TokenChangeHelper(onTokenChange);
        return single.onErrorResumeNext(throwable -> Single.error((Throwable)ErrorMessageException.fromRawThrowable(throwable))).doOnSuccess(authenticationToken -> helper.preTokenChange(this.lastToken, authenticationToken)).flatMap((Function)new Function<AuthenticationToken, SingleSource<String>>(){

            public SingleSource<String> apply(AuthenticationToken authenticationToken) throws Exception {
                if (TokenAuthenticator.this.changeToken(authenticationToken)) {
                    return Single.just((Object)authenticationToken.getUserid());
                }
                return Single.error((Throwable)new ErrorMessageException(authenticationToken.getError()));
            }
        }).doOnSuccess(username -> helper.postTokenChange(this.lastToken)).doOnError(throwable -> Logging.d((String)LOG_TAG, (Throwable)throwable, (Object[])new Object[]{" onError while authenticate", throwable}));
    }

    public void signOut() {
        this.dropToken();
    }

    private void dropToken() {
        this.lastToken = Token.NO_TOKEN;
        this.tokenStorage.removeSync();
    }

    public void setSignUpAPI(SignUpAPI signUpAPI) {
        this.signUpAPI = signUpAPI;
    }

    Observable<Token> observeToken() {
        return this.tokenStorage.observe();
    }

    private class TokenChangeHelper {
        private final BiConsumer<Token, Token> onTokenChange;
        private Token previousToken;

        public TokenChangeHelper(BiConsumer<Token, Token> onTokenChange) {
            this.onTokenChange = onTokenChange;
        }

        private void preTokenChange(Token previousToken, Token nextToken) {
            this.previousToken = previousToken;
        }

        private void postTokenChange(Token nextToken) {
            try {
                this.onTokenChange.accept((Object)this.previousToken, (Object)nextToken);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

