/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core.authentication;

import com.gfycat.core.gfycatapi.pojo.ErrorMessage;
import com.gfycat.core.gfycatapi.pojo.GenericResponse;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import java.io.IOException;
import retrofit2.HttpException;

public class ErrorMessageException
extends Throwable {
    private final ErrorMessage errorMessage;

    public static ErrorMessageException fromRawThrowable(Throwable throwable) {
        if (throwable instanceof ErrorMessageException) {
            return (ErrorMessageException)throwable;
        }
        if (throwable instanceof HttpException) {
            HttpException httpException = (HttpException)throwable;
            GenericResponse genericResponse = null;
            try {
                genericResponse = (GenericResponse)new Gson().fromJson(httpException.response().errorBody().charStream(), GenericResponse.class);
            }
            catch (JsonIOException e) {
                return new ErrorMessageException(new ErrorMessage("WrongServerResponse", "Wrong error message format."));
            }
            if (genericResponse == null || genericResponse.getErrorMessage() == null || genericResponse.getErrorMessage().getCode() == null) {
                return new ErrorMessageException(new ErrorMessage("WrongServerResponse", "Wrong error message format."));
            }
            return new ErrorMessageException(genericResponse.getErrorMessage());
        }
        if (throwable instanceof IOException) {
            return new ErrorMessageException(new ErrorMessage("NoResponseFromServer", "Please check internet connection."));
        }
        return new ErrorMessageException(new ErrorMessage("InternalApplicationError", "Please try again later."));
    }

    public ErrorMessageException(ErrorMessage errorMessage) {
        this.errorMessage = errorMessage;
    }

    public ErrorMessage getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String toString() {
        return "ErrorMessageException{errorMessage=" + this.errorMessage + '}';
    }
}

