/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core;

import android.content.Context;
import android.content.SharedPreferences;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class SingleObjectRepository<T> {
    private static final Gson gson = new Gson();
    private final SharedPreferences preferences;
    private final String key;
    private final Class<? extends T> clazz;
    private final T defaultValue;
    private static Map<String, AtomicReference<Object>> lazyValues = new HashMap<String, AtomicReference<Object>>();
    private final String logTag;

    public SingleObjectRepository(Context context, String key, Class<? extends T> clazz, @NonNull T defaultValue) {
        this.preferences = context.getSharedPreferences(key, 0);
        this.key = key;
        this.clazz = clazz;
        this.defaultValue = defaultValue;
        this.logTag = "SOR_" + key;
    }

    public void putSync(@NonNull T value) {
        this.basePut(value, (Consumer<SharedPreferences.Editor>)((Consumer)SharedPreferences.Editor::commit));
    }

    public void put(@NonNull T value) {
        this.basePut(value, (Consumer<SharedPreferences.Editor>)((Consumer)SharedPreferences.Editor::apply));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basePut(@NonNull T value, Consumer<SharedPreferences.Editor> applyOrCommit) {
        Logging.d((String)this.logTag, (Object[])new Object[]{"put(", value, ")"});
        try {
            Class<? extends T> clazz = this.clazz;
            synchronized (clazz) {
                this.lazySet(value);
                applyOrCommit.accept((Object)this.preferences.edit().putString(this.key, gson.toJson(value)));
            }
        }
        catch (JsonIOException e) {
            Assertions.fail((Throwable)new Exception("Can not save value: " + value + " for class: " + this.clazz, e));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        Class<? extends T> clazz = this.clazz;
        synchronized (clazz) {
            lazyValues.remove(this.key);
            this.preferences.edit().remove(this.key).apply();
        }
    }

    public void removeSync() {
        this.baseRemove((Consumer<SharedPreferences.Editor>)((Consumer)SharedPreferences.Editor::commit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void baseRemove(Consumer<SharedPreferences.Editor> applyOrCommit) {
        Class<? extends T> clazz = this.clazz;
        synchronized (clazz) {
            lazyValues.remove(this.key);
            try {
                applyOrCommit.accept((Object)this.preferences.edit().remove(this.key));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public T get() {
        Object result = this.lazyGet();
        if (result == null) {
            try {
                Class<? extends T> clazz = this.clazz;
                synchronized (clazz) {
                    if (this.preferences.contains(this.key)) {
                        result = gson.fromJson(this.preferences.getString(this.key, null), this.clazz);
                        this.lazySet(result);
                    }
                }
            }
            catch (JsonIOException e) {
                Assertions.fail((Throwable)new Exception("Can not read value " + this.preferences.getString(this.key, null) + " for class: " + this.clazz, e));
                this.remove();
            }
        }
        return result == null ? this.defaultValue : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private T lazyGet() {
        Class<? extends T> clazz = this.clazz;
        synchronized (clazz) {
            AtomicReference<Object> ref = lazyValues.get(this.key);
            return (T)(ref != null ? ref.get() : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazySet(@NonNull T value) {
        Class<? extends T> clazz = this.clazz;
        synchronized (clazz) {
            lazyValues.put(this.key, new AtomicReference<T>(value));
        }
    }

    public Observable<T> observe() {
        return Observable.create(subscriber -> {
            subscriber.onNext(this.get());
            SharedPreferences.OnSharedPreferenceChangeListener internalListener = (sharedPreferences, key1) -> subscriber.onNext(this.get());
            this.preferences.registerOnSharedPreferenceChangeListener(internalListener);
            subscriber.setCancellable(() -> this.preferences.unregisterOnSharedPreferenceChangeListener(internalListener));
        });
    }
}

