/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core;

import android.text.TextUtils;
import com.gfycat.common.utils.Utils;
import com.gfycat.core.FeedIdentifier;
import com.gfycat.core.FeedType;

public class SingleFeedIdentifier
implements FeedIdentifier {
    private final String gfyId;

    public SingleFeedIdentifier(String gfyId) {
        this.gfyId = gfyId;
    }

    static FeedIdentifier create(String uniqueFeedIdentifier) {
        String[] keyAndName = uniqueFeedIdentifier.split(":");
        if (keyAndName.length != 2) {
            throw new IllegalStateException("Provided uniqueFeedIdentifier(" + uniqueFeedIdentifier + ") malformed.");
        }
        if (!FeedIdentifier.Type.SINGLE.getName().equals(keyAndName[0])) {
            throw new IllegalArgumentException("Provided uniqueFeedIdentifier = " + uniqueFeedIdentifier + " is not single, it should start from " + FeedIdentifier.Type.SINGLE.getName());
        }
        if (TextUtils.isEmpty((CharSequence)keyAndName[1])) {
            throw new IllegalStateException("gfyId is mull or empty in uniqueFeedIdentifier = " + uniqueFeedIdentifier);
        }
        return new SingleFeedIdentifier(keyAndName[1]);
    }

    @Override
    public FeedType getType() {
        return FeedIdentifier.Type.SINGLE;
    }

    @Override
    public String toName() {
        return this.gfyId;
    }

    @Override
    public String toUniqueIdentifier() {
        return this.getType().getName() + ":" + this.gfyId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleFeedIdentifier that = (SingleFeedIdentifier)o;
        return Utils.equals((Object)this.gfyId, (Object)that.gfyId);
    }

    public int hashCode() {
        return Utils.hash((Object[])new Object[]{this.gfyId});
    }
}

