/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core;

import android.net.Uri;
import android.text.TextUtils;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Utils;
import com.gfycat.core.FeedIdentifier;
import com.gfycat.core.FeedType;
import com.gfycat.core.SingleFeedIdentifier;

public class PublicFeedIdentifier
implements FeedIdentifier {
    static final String PUBLIC_IDENTIFIER_SCHEME = "public";
    static final String TRENDING_ENDPOINT = "/gfycats/trending";
    static final String SEARCH_ENDPOINT = "/gfycats/search";
    static final String SOUND_ENDPOINT = "/sound";
    static final String SOUND_SEARCH_ENDPOINT = "/sound/search";
    static final String REACTIONS_ENDPOINT = "/reactions/populated";
    static final String ME_ENDPOINT = "/me/gfycats";
    static final String USER_ENDPOINT = "/users/gfycats";
    private static final FeedIdentifier TRENDING = new PublicFeedIdentifier(new Uri.Builder().scheme("public").path("/gfycats/trending").build());
    private static final FeedIdentifier SOUND_TRENDING = new PublicFeedIdentifier(new Uri.Builder().scheme("public").path("/sound").build());
    private static final FeedIdentifier ME = new PublicFeedIdentifier(new Uri.Builder().scheme("public").path("/me/gfycats").build());
    private final FeedType feedType;
    private final Uri uri;

    static FeedIdentifier create(String uniqueFeedIdentifier) {
        return new PublicFeedIdentifier(Uri.parse((String)uniqueFeedIdentifier));
    }

    private static FeedType resolveFeedType(Uri uri) {
        String uriPath = uri.getPath();
        if (SOUND_ENDPOINT.equals(uriPath)) {
            return FeedIdentifier.Type.SOUND_TRENDING;
        }
        if (SOUND_SEARCH_ENDPOINT.equals(uriPath) && !TextUtils.isEmpty((CharSequence)uri.getQueryParameter("search_text"))) {
            return FeedIdentifier.Type.SOUND_SEARCH;
        }
        if (SEARCH_ENDPOINT.equals(uriPath) && !TextUtils.isEmpty((CharSequence)uri.getQueryParameter("search_text"))) {
            return FeedIdentifier.Type.SEARCH;
        }
        if (REACTIONS_ENDPOINT.equals(uriPath) && !TextUtils.isEmpty((CharSequence)uri.getQueryParameter("tagName"))) {
            return FeedIdentifier.Type.REACTIONS;
        }
        if (TRENDING_ENDPOINT.equals(uriPath) && !TextUtils.isEmpty((CharSequence)uri.getQueryParameter("tagName"))) {
            return FeedIdentifier.Type.TAG;
        }
        if (TRENDING_ENDPOINT.equals(uriPath)) {
            return FeedIdentifier.Type.TRENDING;
        }
        if (ME_ENDPOINT.equals(uriPath)) {
            return FeedIdentifier.Type.ME;
        }
        if (USER_ENDPOINT.equals(uriPath) && !TextUtils.isEmpty((CharSequence)uri.getQueryParameter("username"))) {
            return FeedIdentifier.Type.USER;
        }
        Assertions.fail((Throwable)new IllegalStateException("Feed resolution failed from uri = " + uri));
        return null;
    }

    public static FeedIdentifier myGfycats() {
        return ME;
    }

    public static FeedIdentifier trending() {
        return TRENDING;
    }

    public static FeedIdentifier soundTrending() {
        return SOUND_TRENDING;
    }

    public static FeedIdentifier fromSingleItem(String gfyId) {
        return new SingleFeedIdentifier(gfyId);
    }

    public static FeedIdentifier fromSoundSearch(String searchQuery) {
        return new PublicFeedIdentifier(new Uri.Builder().scheme(PUBLIC_IDENTIFIER_SCHEME).path(SOUND_SEARCH_ENDPOINT).appendQueryParameter("search_text", searchQuery).appendQueryParameter("name", searchQuery).build());
    }

    public static FeedIdentifier fromTagName(String tagName) {
        return new PublicFeedIdentifier(new Uri.Builder().scheme(PUBLIC_IDENTIFIER_SCHEME).path(TRENDING_ENDPOINT).appendQueryParameter("tagName", tagName).appendQueryParameter("name", tagName).build());
    }

    public static FeedIdentifier fromReaction(String reactionName) {
        return new PublicFeedIdentifier(new Uri.Builder().scheme(PUBLIC_IDENTIFIER_SCHEME).path(REACTIONS_ENDPOINT).appendQueryParameter("tagName", reactionName).appendQueryParameter("name", reactionName).build());
    }

    public static FeedIdentifier fromUsername(String username) {
        return new PublicFeedIdentifier(new Uri.Builder().scheme(PUBLIC_IDENTIFIER_SCHEME).path(USER_ENDPOINT).appendQueryParameter("name", username).appendQueryParameter("username", username).build());
    }

    public static FeedIdentifier fromSearch(String searchQuery) {
        return new PublicFeedIdentifier(new Uri.Builder().scheme(PUBLIC_IDENTIFIER_SCHEME).path(SEARCH_ENDPOINT).appendQueryParameter("search_text", searchQuery).appendQueryParameter("name", searchQuery).build());
    }

    PublicFeedIdentifier(Uri uri) {
        if (!PUBLIC_IDENTIFIER_SCHEME.equals(uri.getScheme())) {
            throw new IllegalStateException("Unuspported uri = " + uri.toString());
        }
        this.uri = uri;
        this.feedType = PublicFeedIdentifier.resolveFeedType(uri);
        if (this.feedType == null) {
            throw new IllegalArgumentException("Feed uri = " + uri + " not supported.");
        }
    }

    Uri getUri() {
        return this.uri;
    }

    @Override
    public FeedType getType() {
        return this.feedType;
    }

    @Override
    public String toName() {
        String nameParameter = this.uri.getQueryParameter("name");
        return nameParameter != null ? nameParameter : "";
    }

    @Override
    public String toUniqueIdentifier() {
        return this.uri.toString();
    }

    public String getParameter(String parameterName) {
        return this.uri.getQueryParameter(parameterName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicFeedIdentifier that = (PublicFeedIdentifier)o;
        return Utils.equals((Object)this.uri, (Object)that.uri);
    }

    public int hashCode() {
        return Utils.hash((Object[])new Object[]{this.uri});
    }
}

