/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core;

import android.net.Uri;
import com.gfycat.common.utils.Utils;
import com.gfycat.core.FeedIdentifier;
import com.gfycat.core.FeedIdentifierParameters;
import com.gfycat.core.FeedType;
import com.gfycat.core.PublicFeedIdentifier;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import java.util.Arrays;

public class ParameterizedFeedIdentifierBuilder {
    private static FeedType[] SUPPORTED_FEED_TYPES = new FeedType[]{FeedIdentifier.Type.SEARCH, FeedIdentifier.Type.SOUND_SEARCH, FeedIdentifier.Type.SOUND_TRENDING};
    private final Uri.Builder baseUriBuilder;

    public static boolean supportsParametrization(FeedIdentifier feedIdentifier) {
        return Utils.contains((Object[])SUPPORTED_FEED_TYPES, (Object)feedIdentifier) && feedIdentifier instanceof PublicFeedIdentifier;
    }

    public ParameterizedFeedIdentifierBuilder(FeedIdentifier baseFeedIdentifier) {
        if (!Utils.contains((Object[])SUPPORTED_FEED_TYPES, (Object)baseFeedIdentifier.getType())) {
            throw new IllegalArgumentException("Please provide feed type with one of next types: " + Arrays.toString(SUPPORTED_FEED_TYPES));
        }
        if (!(baseFeedIdentifier instanceof PublicFeedIdentifier)) {
            throw new IllegalArgumentException("ParameterizedFeedIdentifierBuilder not supports custom feed identifier.");
        }
        this.baseUriBuilder = ((PublicFeedIdentifier)baseFeedIdentifier).getUri().buildUpon();
    }

    public ParameterizedFeedIdentifierBuilder withMinAspectRatio(float minAspectRatio) {
        if (minAspectRatio < 0.1f) {
            minAspectRatio = 0.1f;
        }
        if (minAspectRatio > 10.0f) {
            minAspectRatio = 10.0f;
        }
        this.baseUriBuilder.appendQueryParameter("minAspectRation", FeedIdentifierParameters.formatAspect(minAspectRatio));
        return this;
    }

    public ParameterizedFeedIdentifierBuilder withMaxAspectRatio(float maxAspectRatio) {
        if (maxAspectRatio < 0.1f) {
            maxAspectRatio = 0.1f;
        }
        if (maxAspectRatio > 10.0f) {
            maxAspectRatio = 10.0f;
        }
        this.baseUriBuilder.appendQueryParameter("maxAspectRation", FeedIdentifierParameters.formatAspect(maxAspectRatio));
        return this;
    }

    public ParameterizedFeedIdentifierBuilder withMinLength(float minLength) {
        if (minLength < 0.0f) {
            minLength = 0.0f;
        }
        if (minLength > 60.0f) {
            minLength = 60.0f;
        }
        this.baseUriBuilder.appendQueryParameter("minLength", FeedIdentifierParameters.formatLength(minLength));
        return this;
    }

    public ParameterizedFeedIdentifierBuilder withMaxLength(float maxLength) {
        if (maxLength < 0.0f) {
            maxLength = 0.0f;
        }
        if (maxLength > 60.0f) {
            maxLength = 60.0f;
        }
        this.baseUriBuilder.appendQueryParameter("maxLength", FeedIdentifierParameters.formatLength(maxLength));
        return this;
    }

    public ParameterizedFeedIdentifierBuilder withContentRating(Gfycat.ContentRating contentRating) {
        this.baseUriBuilder.appendQueryParameter("contentRating", contentRating.urlEncodedValue);
        return this;
    }

    public FeedIdentifier build() {
        return new PublicFeedIdentifier(this.baseUriBuilder.build());
    }
}

