/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core;

import com.gfycat.common.ChainedException;
import com.gfycat.common.utils.Assertions;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class NetworkUtils {
    public static String getPublicUrlForGfyName(String gfyName) {
        return "https://gfycat.com/" + gfyName;
    }

    public static boolean isAcceptableNetworkException(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        return throwable instanceof ConnectException || throwable instanceof UnknownHostException || throwable instanceof SocketTimeoutException || throwable instanceof SocketException || NetworkUtils.isAcceptableNetworkException(throwable.getCause());
    }

    public static void reportIfNotAcceptable(Throwable throwable) {
        if (!NetworkUtils.isAcceptableNetworkException(throwable)) {
            Assertions.fail((Throwable)new ChainedException(throwable));
        }
    }
}

