/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.gfycat.core.GfycatPlugin;

public class GfycatPluginInitializer {
    private static final String LOG_TAG = "GfycatPluginInitializer";
    private static final String[] PLUGIN_KEYS = new String[]{"picker_categories_prefetch_plugin", "creation_finalization_plugin", "photo_moments_initialization_plugin"};

    public static void initialize(Context context) {
        Logging.d((String)LOG_TAG, (String)"initialize()");
        for (String plugin : PLUGIN_KEYS) {
            GfycatPluginInitializer.initializePlugin(plugin, context);
        }
    }

    private static void initializePlugin(String pluginKey, Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (appInfo != null && appInfo.metaData != null) {
                String className = appInfo.metaData.getString(pluginKey);
                if (!TextUtils.isEmpty((CharSequence)className)) {
                    Class<?> clazz = Class.forName(className);
                    GfycatPlugin gfycatPlugin = (GfycatPlugin)clazz.newInstance();
                    try {
                        gfycatPlugin.initialize(context.getApplicationContext());
                    }
                    catch (Throwable throwable) {
                        Logging.e((String)LOG_TAG, (Throwable)throwable, (Object[])new Object[]{"Failed to initialize plugin(" + pluginKey + ")"});
                        Assertions.fail((Throwable)new IllegalStateException("Failed to initialize " + pluginKey, throwable));
                    }
                } else {
                    Logging.d((String)LOG_TAG, (Object[])new Object[]{"Plugin [", pluginKey, "] was not provided."});
                }
            }
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            Logging.e((String)LOG_TAG, (Throwable)e, (Object[])new Object[]{"Failed to initialize plugin(" + pluginKey + ")"});
        }
    }
}

