/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core;

import com.gfycat.core.GfyCoreInitializer;
import com.gfycat.core.authentication.UserAccountManagerImpl;
import com.gfycat.core.creation.CreationAPI;
import com.gfycat.core.downloading.FeedManagerImpl;
import okhttp3.OkHttpClient;

public class GfyPrivate {
    private static long DEFAULT_INITIALIZATION_TIMEOUT = 5000L;
    private static GfyPrivate INSTANCE = null;
    private final String domainName;
    private final OkHttpClient videoDownloadingClient;
    private final CreationAPI creationAPI;
    private final UserAccountManagerImpl userAccountManager;
    private final FeedManagerImpl feedManager;

    private GfyPrivate(String domainName, OkHttpClient videoDownloadingClient, CreationAPI getCreationApi, UserAccountManagerImpl userAccountManager, FeedManagerImpl feedManager) {
        this.domainName = domainName;
        this.videoDownloadingClient = videoDownloadingClient;
        this.creationAPI = getCreationApi;
        this.userAccountManager = userAccountManager;
        this.feedManager = feedManager;
    }

    static synchronized void initialize(String domainName, OkHttpClient videoDownloadingClient, CreationAPI getCreationApi, UserAccountManagerImpl userAccountManager, FeedManagerImpl feedManager) {
        INSTANCE = new GfyPrivate(domainName, videoDownloadingClient, getCreationApi, userAccountManager, feedManager);
    }

    public static GfyPrivate get() {
        if (INSTANCE == null) {
            if (GfyCoreInitializer.initializePerformed()) {
                long start = System.currentTimeMillis();
                do {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while (INSTANCE == null && System.currentTimeMillis() - start < DEFAULT_INITIALIZATION_TIMEOUT);
                if (INSTANCE == null) {
                    throw new IllegalStateException("Timeout! Gfycat SDK have not been initialized for a long time!");
                }
            } else {
                throw new IllegalStateException("Gfycat SDK is not initialized!");
            }
        }
        return INSTANCE;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public OkHttpClient getVideoDownloadingClient() {
        return this.videoDownloadingClient;
    }

    public CreationAPI getCreationAPI() {
        return this.creationAPI;
    }

    public UserAccountManagerImpl getUserAccountManager() {
        return this.userAccountManager;
    }

    public FeedManagerImpl getFeedManager() {
        return this.feedManager;
    }

    void deInit() {
        INSTANCE = null;
    }
}

