/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import com.gfycat.common.Action1;
import com.gfycat.common.ChainedException;
import com.gfycat.common.utils.Assertions;
import com.gfycat.common.utils.Logging;
import com.gfycat.core.AdsManager;
import com.gfycat.core.GfyCore;
import com.gfycat.core.GfyCoreInitializationBuilder;
import com.gfycat.core.GfyPrivate;
import com.gfycat.core.GfycatApplicationInfo;
import com.gfycat.core.GfycatCustomDomain;
import com.gfycat.core.GfycatPluginInitializer;
import com.gfycat.core.NetworkConfig;
import com.gfycat.core.NoAuthAPI;
import com.gfycat.core.PublicFeedIdentifier;
import com.gfycat.core.authentication.AuthenticationAPI;
import com.gfycat.core.authentication.SignUpAPI;
import com.gfycat.core.authentication.TokenAuthenticator;
import com.gfycat.core.authentication.UserAccountManagerImpl;
import com.gfycat.core.bi.analytics.GfycatAnalytics;
import com.gfycat.core.bi.analytics.MetricsEngine;
import com.gfycat.core.bi.corelogger.CoreLogger;
import com.gfycat.core.bi.corelogger.CoreLoggerImpl;
import com.gfycat.core.bi.impression.GfycatImpression;
import com.gfycat.core.contentmanagement.NSFWContentManagerImpl;
import com.gfycat.core.contentmanagement.UserOwnedContentManagerImpl;
import com.gfycat.core.creation.CreationAPI;
import com.gfycat.core.creation.DefaultUploadManager;
import com.gfycat.core.db.GfycatFeedDatabaseCache;
import com.gfycat.core.downloading.CategoriesCache;
import com.gfycat.core.downloading.FeedManagerImpl;
import com.gfycat.core.gfycatapi.GfycatAPI;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import com.gfycat.core.storage.CachedMediaFilesManager;
import com.gfycat.core.storage.DefaultDiskCache;
import com.gfycat.disklrucache.DiskLruCache;
import io.reactivex.Completable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class GfyCoreInitializer {
    private static final String LOG_TAG = "GfyCoreInitializer";
    private static final int MAX_DOWNLOADING_VIDEOS_COUNT = 2;
    private static boolean initializationPerformed;
    static volatile boolean initializationCompleted;

    public static synchronized void initialize(GfyCoreInitializationBuilder builder) {
        if (initializationPerformed) {
            Assertions.fail((Throwable)new IllegalStateException("GfyCoreInitializer.initialize() called more than once."));
        } else {
            initializationPerformed = true;
            GfyCoreInitializer.coreInitSingleObservable(builder).subscribeOn(Schedulers.io()).doOnError(throwable -> Assertions.fail((Throwable)new ChainedException(throwable))).subscribe();
        }
    }

    static boolean initializePerformed() {
        return initializationPerformed;
    }

    private static Completable coreInitSingleObservable(GfyCoreInitializationBuilder builder) {
        return Completable.create(subscriber -> {
            Logging.d((String)LOG_TAG, (String)"initialization start");
            DiskLruCache.setupAssertionsLogger((Action1<Throwable>)((Action1)throwable -> Assertions.fail((Throwable)new ChainedException(throwable))));
            Queue<File> cacheFolderOptions = builder.getCacheFolder() == null ? GfyCoreInitializer.collectCacheVariants(builder.getContext()) : new LinkedList<File>(Collections.singletonList(builder.getCacheFolder()));
            DefaultDiskCache diskCache = DefaultDiskCache.initialize(cacheFolderOptions, builder.getCacheSizeOptions());
            String appDomainName = GfyCoreInitializer.getApplicationDomain(builder.getGfycatApplicationInfo());
            OkHttpClient.Builder videoClientBuilder = new OkHttpClient.Builder().cache(null).connectionPool(new ConnectionPool(0, 1L, TimeUnit.SECONDS)).protocols(Collections.singletonList(Protocol.HTTP_1_1)).dispatcher(new Dispatcher(Executors.newFixedThreadPool(2)));
            AuthenticationAPI authenticationApi = (AuthenticationAPI)new Retrofit.Builder().addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(new OkHttpClient.Builder().addInterceptor(builder.getJsonInterceptor()).build()).baseUrl(NetworkConfig.buildApiUrl(appDomainName)).build().create(AuthenticationAPI.class);
            TokenAuthenticator authenticator = new TokenAuthenticator(builder.getContext(), builder.getGfycatApplicationInfo(), authenticationApi);
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().authenticator((Authenticator)authenticator).addInterceptor((Interceptor)authenticator).addInterceptor(builder.getJsonInterceptor());
            OkHttpClient client = clientBuilder.build();
            OkHttpClient noAuthClient = new OkHttpClient.Builder().addInterceptor(builder.getMediaInterceptor()).build();
            OkHttpClient videoClient = videoClientBuilder.addInterceptor(builder.getMediaInterceptor()).retryOnConnectionFailure(false).build();
            String apiUrl = NetworkConfig.buildApiUrl(appDomainName);
            SignUpAPI signUpApi = GfyCoreInitializer.buildGeneralApi(apiUrl, client, SignUpAPI.class);
            GfycatAPI gfycatApi = GfyCoreInitializer.buildGeneralApi(apiUrl, client, GfycatAPI.class);
            CreationAPI creationApi = GfyCoreInitializer.buildGeneralApi(apiUrl, client, CreationAPI.class);
            NoAuthAPI noAuthApi = GfyCoreInitializer.buildGeneralApi(apiUrl, noAuthClient, NoAuthAPI.class);
            authenticator.setSignUpAPI(signUpApi);
            GfycatFeedDatabaseCache feedCache = new GfycatFeedDatabaseCache(builder.getContext());
            FeedManagerImpl feedManager = new FeedManagerImpl(new CategoriesCache(builder.getContext()), gfycatApi, feedCache);
            GfyCore.get().initFeedManager(feedManager);
            UserAccountManagerImpl userAccountManager = new UserAccountManagerImpl(builder.getContext(), authenticator, gfycatApi, noAuthApi, () -> {
                feedCache.delete(PublicFeedIdentifier.myGfycats());
                builder.getDropUserRelatedContent();
            });
            GfyCore.get().initUserAccountManager(userAccountManager);
            CachedMediaFilesManager videoDownloadingManager = new CachedMediaFilesManager(videoClient, diskCache);
            GfyCore.get().initMediaFilesManager(videoDownloadingManager);
            NSFWContentManagerImpl nsfwContentManager = new NSFWContentManagerImpl(gfycatApi, feedCache);
            GfyCore.get().initNsfwContentManager(nsfwContentManager);
            UserOwnedContentManagerImpl userOwnedContentManager = new UserOwnedContentManagerImpl(gfycatApi, creationApi, feedCache);
            GfyCore.get().initUserOwnedContentManager(userOwnedContentManager);
            DefaultUploadManager uploadManager = new DefaultUploadManager(creationApi, videoClient, NetworkConfig.buildUploadUrl(appDomainName), gfyName -> (Gfycat)feedManager.getGfycat(gfyName).blockingGet());
            GfyCore.get().initUploadManager(uploadManager);
            GfyPrivate.initialize(appDomainName, videoClient, creationApi, userAccountManager, feedManager);
            GfycatImpression.initialize(builder.getContext(), builder.getGfycatApplicationInfo());
            GfycatAnalytics.addEngine(new MetricsEngine(builder.getContext(), builder.getGfycatApplicationInfo()));
            GfycatAnalytics.addLogger(CoreLogger.class, new CoreLoggerImpl());
            GfyCoreInitializer.initializeAdsPlugin(builder.getContext());
            GfycatPluginInitializer.initialize(builder.getContext());
            Logging.d((String)LOG_TAG, (String)"initialization end");
            initializationCompleted = true;
            subscriber.onComplete();
        });
    }

    private static void initializeAdsPlugin(Context context) {
        AdsManager.initialize(context);
    }

    private static boolean isCustomDomainAllowed(GfycatApplicationInfo applicationInfo) {
        return Pattern.matches("\\b3_.*", applicationInfo.clientId);
    }

    private static String getApplicationDomain(GfycatApplicationInfo applicationInfo) {
        if (applicationInfo instanceof GfycatCustomDomain && GfyCoreInitializer.isCustomDomainAllowed(applicationInfo)) {
            return ((GfycatCustomDomain)((Object)applicationInfo)).getDomain();
        }
        return "gfycat.com";
    }

    private static Queue<File> collectCacheVariants(Context context) {
        LinkedList<File> cacheVariants = new LinkedList<File>();
        try {
            cacheVariants.addAll(Arrays.asList(ContextCompat.getExternalCacheDirs((Context)context)));
        }
        catch (NullPointerException e) {
            Assertions.fail((Throwable)e);
        }
        cacheVariants.add(context.getCacheDir());
        return cacheVariants;
    }

    private static <T> T buildGeneralApi(String baseUrl, OkHttpClient client, Class<T> clazz) {
        return (T)new Retrofit.Builder().addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(client).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).baseUrl(baseUrl).build().create(clazz);
    }

    static void deInitialize() {
        GfyCore.get().deInit();
        GfyPrivate.get().deInit();
        initializationPerformed = false;
        initializationCompleted = false;
    }
}

