/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core;

import android.content.Context;
import android.text.TextUtils;
import com.gfycat.core.GfycatApplicationInfo;
import com.gfycat.core.storage.DefaultDiskCache;
import java.io.File;
import okhttp3.Interceptor;

public class GfyCoreInitializationBuilder {
    private final Context context;
    private final GfycatApplicationInfo gfycatApplicationInfo;
    private File cacheFolder;
    private Interceptor jsonInterceptor;
    private Interceptor mediaInterceptor;
    private Runnable dropUserRelatedContent;
    private DefaultDiskCache.CacheSizeOptions cacheSizeOptions = new DefaultDiskCache.CacheSizeOptions();
    private static Interceptor NO_INTERCEPTOR = chain -> chain.proceed(chain.request());
    private static Runnable NO_DROP_USER_CONTENT = () -> {};

    public GfyCoreInitializationBuilder(Context context, GfycatApplicationInfo gfycatApplicationInfo) {
        if (context == null) {
            throw new NullPointerException("Context should not be null");
        }
        if (gfycatApplicationInfo == null) {
            throw new NullPointerException("AppInfo should not be null");
        }
        if (TextUtils.isEmpty((CharSequence)gfycatApplicationInfo.clientId)) {
            throw new IllegalArgumentException("gfycatApplicationInfo.clientId should be not empty.");
        }
        if (TextUtils.isEmpty((CharSequence)gfycatApplicationInfo.clientSecret)) {
            throw new IllegalArgumentException("gfycatApplicationInfo.clientSecret should be not empty.");
        }
        this.context = context.getApplicationContext();
        this.gfycatApplicationInfo = gfycatApplicationInfo;
    }

    public GfyCoreInitializationBuilder setMinCacheSpace(long megabytes) {
        this.cacheSizeOptions.setMinSpace(megabytes);
        return this;
    }

    public GfyCoreInitializationBuilder setMaxCacheSpace(long megabytes) {
        this.cacheSizeOptions.setMaxSpace(megabytes);
        return this;
    }

    public GfyCoreInitializationBuilder setCacheFolder(File cacheFolder) throws CacheFolderDoesNotExist, CacheFolderIsNotDirectory {
        if (!cacheFolder.exists()) {
            throw new CacheFolderDoesNotExist(cacheFolder);
        }
        if (!cacheFolder.isDirectory()) {
            throw new CacheFolderIsNotDirectory(cacheFolder);
        }
        this.cacheFolder = cacheFolder;
        return this;
    }

    GfyCoreInitializationBuilder setJsonInterceptor(Interceptor interceptor) {
        this.jsonInterceptor = interceptor;
        return this;
    }

    GfyCoreInitializationBuilder setVideoInterceptor(Interceptor interceptor) {
        this.mediaInterceptor = interceptor;
        return this;
    }

    public GfyCoreInitializationBuilder setDropUserRelatedContentCallback(Runnable dropUserRelatedContent) {
        this.dropUserRelatedContent = dropUserRelatedContent;
        return this;
    }

    Context getContext() {
        return this.context;
    }

    GfycatApplicationInfo getGfycatApplicationInfo() {
        return this.gfycatApplicationInfo;
    }

    File getCacheFolder() {
        return this.cacheFolder;
    }

    DefaultDiskCache.CacheSizeOptions getCacheSizeOptions() {
        return this.cacheSizeOptions;
    }

    Interceptor getMediaInterceptor() {
        return this.mediaInterceptor == null ? NO_INTERCEPTOR : this.mediaInterceptor;
    }

    Interceptor getJsonInterceptor() {
        return this.jsonInterceptor == null ? NO_INTERCEPTOR : this.jsonInterceptor;
    }

    Runnable getDropUserRelatedContent() {
        return this.dropUserRelatedContent == null ? NO_DROP_USER_CONTENT : this.dropUserRelatedContent;
    }

    public class CacheFolderIsNotDirectory
    extends Throwable {
        CacheFolderIsNotDirectory(File file) {
            super("Provided file = " + file + " path is not directory.");
        }
    }

    public class CacheFolderDoesNotExist
    extends Throwable {
        CacheFolderDoesNotExist(File file) {
            super("Provided file = " + file + " path not exists.");
        }
    }
}

