/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core;

import android.content.Context;
import com.gfycat.core.FeedIdentifier;
import com.gfycat.core.downloading.FeedData;
import com.gfycat.core.downloading.FeedDescription;
import com.gfycat.core.downloading.FeedManager;
import com.gfycat.core.gfycatapi.pojo.Gfycat;
import com.gfycat.core.gfycatapi.pojo.GfycatCategoriesList;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.subjects.ReplaySubject;

public class FeedManagerAsyncWrapper
implements FeedManager {
    private ReplaySubject<FeedManager> subject = ReplaySubject.create();

    public void init(FeedManager feedManager) {
        if (this.subject.hasComplete()) {
            return;
        }
        this.subject.onNext((Object)feedManager);
        this.subject.onComplete();
    }

    public Single<FeedManager> observeFeedManager() {
        return this.subject.singleOrError();
    }

    @Override
    public Observable<GfycatCategoriesList> getCategories() {
        return this.subject.singleOrError().flatMapObservable(FeedManager::getCategories);
    }

    @Override
    public Flowable<FeedData> observeGfycats(FeedIdentifier feedIdentifier) {
        return this.subject.singleOrError().toFlowable().flatMap(feedManager -> feedManager.observeGfycats(feedIdentifier));
    }

    @Override
    public Flowable<FeedData> observeGfycats(Context context, FeedIdentifier feedIdentifier) {
        return this.subject.singleOrError().toFlowable().flatMap(feedManager -> feedManager.observeGfycats(context, feedIdentifier));
    }

    @Override
    public Completable getGfycats(FeedIdentifier feedIdentifier) {
        return this.subject.singleOrError().flatMapCompletable(feedManager -> feedManager.getGfycats(feedIdentifier));
    }

    @Override
    public Completable getNewGfycats(FeedDescription feedDescription) {
        return this.subject.singleOrError().flatMapCompletable(feedManager -> feedManager.getNewGfycats(feedDescription));
    }

    @Override
    public Completable getMoreGfycats(FeedDescription feedDescription) {
        return this.subject.singleOrError().flatMapCompletable(feedManager -> feedManager.getMoreGfycats(feedDescription));
    }

    @Override
    public Single<Gfycat> getGfycat(String gfyId) {
        return this.subject.singleOrError().flatMap(feedManager -> feedManager.getGfycat(gfyId));
    }
}

