/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core;

import com.gfycat.core.FeedIdentifier;
import com.gfycat.core.PublicFeedIdentifier;
import com.gfycat.core.RecentFeedIdentifier;
import com.gfycat.core.SingleFeedIdentifier;

public class FeedIdentifierFactory {
    public static FeedIdentifier fromUniqueIdentifier(String uniqueIdentifier) throws NoSuchFeedException {
        if (uniqueIdentifier.startsWith("public")) {
            return PublicFeedIdentifier.create(uniqueIdentifier);
        }
        if (uniqueIdentifier.startsWith(RecentFeedIdentifier.RECENT_FEED_TYPE.getName())) {
            return RecentFeedIdentifier.recent();
        }
        if (uniqueIdentifier.startsWith(FeedIdentifier.Type.SINGLE.getName())) {
            return SingleFeedIdentifier.create(uniqueIdentifier);
        }
        throw new NoSuchFeedException(uniqueIdentifier);
    }

    public static class NoSuchFeedException
    extends RuntimeException {
        private NoSuchFeedException(String uniqueIdentifier) {
            super("Can not instantiate feed from uniqueIdentifier = [" + uniqueIdentifier + "]");
        }
    }
}

