/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core;

import com.gfycat.core.FeedType;
import java.io.Serializable;

public interface FeedIdentifier
extends Serializable {
    public FeedType getType();

    public String toName();

    public String toUniqueIdentifier();

    public static enum Type implements FeedType
    {
        TRENDING("trending"),
        TAG("tag"),
        SEARCH("search"),
        SINGLE("single"),
        REACTIONS("reactions"),
        USER("user"),
        ME("me"),
        SOUND_TRENDING("sound_trending"),
        SOUND_SEARCH("sound_search");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        static FeedType fromName(String name) {
            for (Type type : Type.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

