/*
 * Decompiled with CFR 0.152.
 */
package com.gfycat.core;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.gfycat.common.Function;
import com.gfycat.common.utils.Logging;
import com.gfycat.core.ads.AdsPlugin;
import io.reactivex.Single;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.AsyncSubject;

public class AdsManager {
    private static final String LOG_TAG = "AdsManager";
    private static final String META_ADS_FACTORY_CLASS_NAME = "ads_plugin_class_name";
    public static final float MIN_VIEW_TO_SCREEN_HEIGHT_RATIO = 0.6f;
    private static AsyncSubject<AdsPlugin> adsFactorySubject = AsyncSubject.create();
    private static final Disposable HIDE_UNDELIVERABLE_EXCEPTION = adsFactorySubject.subscribe(Function::ignore, Function::ignore);

    static void initialize(Context context) {
        try {
            String className;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (appInfo != null && appInfo.metaData != null && (className = appInfo.metaData.getString(META_ADS_FACTORY_CLASS_NAME)) != null) {
                Class<?> clazz = Class.forName(className);
                AdsPlugin adsPlugin = (AdsPlugin)clazz.newInstance();
                adsPlugin.initialize(context.getApplicationContext());
                Logging.d((String)LOG_TAG, (Object[])new Object[]{"AdsPlugin was provided, class = ", adsPlugin.getClass().getSimpleName()});
                adsFactorySubject.onNext((Object)adsPlugin);
                adsFactorySubject.onComplete();
            }
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException throwable) {
            // empty catch block
        }
        if (!adsFactorySubject.hasComplete()) {
            Logging.d((String)LOG_TAG, (String)"AdsPlugin was not provided");
            adsFactorySubject.onError((Throwable)new AdsUnavailableException());
        }
    }

    public static Single<AdsPlugin> get() {
        return adsFactorySubject.singleOrError();
    }

    static void deInitialize() {
        adsFactorySubject = AsyncSubject.create();
    }

    private static class AdsUnavailableException
    extends Throwable {
        private AdsUnavailableException() {
        }
    }
}

