/*
 * Decompiled with CFR 0.152.
 */
package com.gyf.immersionbar.components;

import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.gyf.immersionbar.components.ImmersionOwner;

@Deprecated
public class ImmersionProxy {
    private Fragment mFragment;
    private ImmersionOwner mImmersionOwner;
    private boolean mIsActivityCreated;
    private boolean mIsLazyAfterView;
    private boolean mIsLazyBeforeView;

    public ImmersionProxy(Fragment fragment) {
        this.mFragment = fragment;
        if (!(fragment instanceof ImmersionOwner)) {
            throw new IllegalArgumentException("Fragment\u8bf7\u5b9e\u73b0ImmersionOwner\u63a5\u53e3");
        }
        this.mImmersionOwner = (ImmersionOwner)fragment;
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        if (this.mFragment != null) {
            if (this.mFragment.getUserVisibleHint()) {
                if (!this.mIsLazyBeforeView) {
                    this.mImmersionOwner.onLazyBeforeView();
                    this.mIsLazyBeforeView = true;
                }
                if (this.mIsActivityCreated && this.mFragment.getUserVisibleHint()) {
                    if (this.mImmersionOwner.immersionBarEnabled()) {
                        this.mImmersionOwner.initImmersionBar();
                    }
                    if (!this.mIsLazyAfterView) {
                        this.mImmersionOwner.onLazyAfterView();
                        this.mIsLazyAfterView = true;
                    }
                    this.mImmersionOwner.onVisible();
                }
            } else if (this.mIsActivityCreated) {
                this.mImmersionOwner.onInvisible();
            }
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        if (this.mFragment != null && this.mFragment.getUserVisibleHint() && !this.mIsLazyBeforeView) {
            this.mImmersionOwner.onLazyBeforeView();
            this.mIsLazyBeforeView = true;
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        this.mIsActivityCreated = true;
        if (this.mFragment != null && this.mFragment.getUserVisibleHint()) {
            if (this.mImmersionOwner.immersionBarEnabled()) {
                this.mImmersionOwner.initImmersionBar();
            }
            if (!this.mIsLazyAfterView) {
                this.mImmersionOwner.onLazyAfterView();
                this.mIsLazyAfterView = true;
            }
        }
    }

    public void onResume() {
        if (this.mFragment != null && this.mFragment.getUserVisibleHint()) {
            this.mImmersionOwner.onVisible();
        }
    }

    public void onPause() {
        if (this.mFragment != null) {
            this.mImmersionOwner.onInvisible();
        }
    }

    public void onDestroy() {
        this.mFragment = null;
        this.mImmersionOwner = null;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (this.mFragment != null && this.mFragment.getUserVisibleHint()) {
            if (this.mImmersionOwner.immersionBarEnabled()) {
                this.mImmersionOwner.initImmersionBar();
            }
            this.mImmersionOwner.onVisible();
        }
    }

    public void onHiddenChanged(boolean hidden) {
        if (this.mFragment != null) {
            this.mFragment.setUserVisibleHint(!hidden);
        }
    }

    public boolean isUserVisibleHint() {
        if (this.mFragment != null) {
            return this.mFragment.getUserVisibleHint();
        }
        return false;
    }
}

