/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.common;

public class ApiResult<T> {
    protected int code;
    protected String msg;
    protected T data;

    public ApiResult() {
    }

    public ApiResult(String message, int code) {
        this.msg = message;
        this.code = code;
    }

    public static <T> ApiResult<T> success(T data) {
        return new ApiResult<T>(data);
    }

    public static ApiResult success() {
        ApiResult apiResult = new ApiResult();
        apiResult.code = 200;
        return apiResult;
    }

    public ApiResult(T data) {
        this.code = 200;
        this.data = data;
    }

    public static ApiResult fail(String msg, int code) {
        return new ApiResult(msg, code);
    }

    public boolean isSuccess() {
        return this.code == 0;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "ApiResult{code=" + this.code + ", msg='" + this.msg + '\'' + ", data=" + this.data + '}';
    }
}

