/*
 * Decompiled with CFR 0.152.
 */
package com.geteasyqa.EasyQA.Plugin;

import com.geteasyqa.EasyQA.Authorization.SignIn;
import com.geteasyqa.EasyQA.Issues.CreateIssue;
import com.geteasyqa.EasyQA.Issues.GetIssues;
import com.geteasyqa.EasyQA.Plugin.User;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jvnet.hudson.test.Issue;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EasyQAServer {
    private static final Logger LOGGER = Logger.getLogger(EasyQAServer.class.getName());
    private final String serverUrl;

    public EasyQAServer(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getErrorMessage(InputStream errorStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(errorStream, StandardCharsets.UTF_8));){
            String l;
            while ((l = bufferedReader.readLine()) != null) {
                stringBuilder.append(l).append("\n");
            }
        }
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            ErrorHandler errorHandler = new ErrorHandler();
            saxParser.parse(new InputSource(new StringReader(stringBuilder.toString())), (DefaultHandler)errorHandler);
            return errorHandler.errorMessage;
        }
        catch (ParserConfigurationException | SAXException e) {
            LOGGER.log(Level.WARNING, "Could not parse error response", e);
            return stringBuilder.toString();
        }
    }

    public Integer createIssue(String project_token, String auth_token, String title, String description) throws IOException {
        return new CreateIssue(this.serverUrl).createIssue(project_token, auth_token, title, description, new String[0]);
    }

    public Integer createIssueWithAttachment(String project_token, String auth_token, String title, String description, ArrayList<File> files) throws IOException {
        return new CreateIssue(this.serverUrl).createIssueWithAttachments(project_token, auth_token, title, files, description, new String[0]);
    }

    public void getProjects(User user) {
        try {
            URL url = new URL(this.serverUrl + "/rest/project/all");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not get YouTrack Projects", e);
        }
    }

    public User getUserByEmail(User user, String email) {
        try {
            URL url = new URL(this.serverUrl + "/rest/admin/user?q=" + email);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            for (String cookie : user.getCookies()) {
                urlConnection.setRequestProperty("Cookie", cookie);
            }
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                SAXParser saxParser = saxParserFactory.newSAXParser();
                User.UserRefHandler dh = new User.UserRefHandler();
                saxParser.parse(urlConnection.getInputStream(), (DefaultHandler)dh);
                return dh.getUser();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not get user", e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.WARNING, "Could not get user", e);
        }
        catch (SAXException e) {
            LOGGER.log(Level.WARNING, "Could not get user", e);
        }
        return null;
    }

    public User login(String project_token, String email, String password) {
        try {
            User user = new User();
            user.setEmail(email);
            user.setPassword(password);
            SignIn signIn = new SignIn(this.serverUrl);
            signIn.signIn(project_token, email, password);
            user.setAuth_token(signIn.getAuth_token_value());
            if (user.getAuth_token() != null) {
                user.setLoggedIn(true);
                return user;
            }
            return user;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not login", e);
            return null;
        }
    }

    public Issue getIssue(User user, String issueId, String project_token) {
        try {
            GetIssues getIssues = new GetIssues(this.serverUrl);
            getIssues.getIssueByProjectID(project_token, user.getAuth_token(), issueId);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not get issue", e);
        }
        return null;
    }

    private static class CreateIssueHandler
    extends DefaultHandler {
        private CreateIssueHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        }
    }

    private static class ErrorHandler
    extends DefaultHandler {
        private StringBuilder stringBuilder = new StringBuilder();
        private boolean inError;
        private String errorMessage;

        private ErrorHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (qName.equals("error")) {
                this.inError = true;
                this.stringBuilder.setLength(0);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (qName.equals("error")) {
                this.errorMessage = this.stringBuilder.toString();
                this.inError = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            if (this.inError) {
                this.stringBuilder.append(ch, start, length);
            }
        }
    }
}

