/*
 * Decompiled with CFR 0.152.
 */
package com.geteasyqa.EasyQA.Issues;

import com.geteasyqa.EasyQA.API.Initialization;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Response;

public class IssueAttachments
extends Initialization {
    public IssueAttachments(String url) {
        super(url);
    }

    public Integer createAttachment(String token, String auth_token, String id, ArrayList<File> files) throws IOException, JSONException {
        HashMap<String, RequestBody> model = new HashMap<String, RequestBody>();
        model.put("token", RequestBody.create((MediaType)this.textType, (String)token));
        model.put("auth_token", RequestBody.create((MediaType)this.textType, (String)auth_token));
        model.put("issue_id", RequestBody.create((MediaType)this.textType, (String)id));
        for (File file : files) {
            String fileName = file.getName();
            model.put(String.format("attachment\"; filename=\"%s", fileName), RequestBody.create((MediaType)(fileName.contains(".mp4") ? this.videoType : this.imageType), (File)file));
        }
        Call<ResponseBody> call = this.easyqaUserAPI.createAttachment(id, model);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        System.out.println(result);
        if (result.startsWith("{")) {
            JSONObject jsonObj = new JSONObject(result);
            Integer id_result = jsonObj.getInt("id");
            return id_result;
        }
        System.out.println(result);
        return null;
    }

    public Integer createAttachmentByIdInProject(String token, String auth_token, String id, ArrayList<File> files) throws IOException, JSONException {
        HashMap<String, RequestBody> model = new HashMap<String, RequestBody>();
        model.put("token", RequestBody.create((MediaType)this.textType, (String)token));
        model.put("auth_token", RequestBody.create((MediaType)this.textType, (String)auth_token));
        model.put("issue_id", RequestBody.create((MediaType)this.textType, (String)id));
        for (File file : files) {
            String fileName = file.getName();
            model.put(String.format("attachment\"; filename=\"%s", fileName), RequestBody.create((MediaType)(fileName.contains(".mp4") ? this.videoType : this.imageType), (File)file));
        }
        Call<ResponseBody> call = this.easyqaUserAPI.createAttachmentByIdInProject(id, model);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        System.out.println(result);
        if (result.startsWith("{")) {
            JSONObject jsonObj = new JSONObject(result);
            Integer id_result = jsonObj.getInt("id");
            return id_result;
        }
        System.out.println(result);
        return null;
    }

    public void deleteAttachmentByID(String token, String auth_token, String id) throws IOException, JSONException {
        JsonObject cred = new JsonObject();
        cred.addProperty("token", token);
        cred.addProperty("auth_token", auth_token);
        Call<ResponseBody> call = this.easyqaUserAPI.deleteAttachment(id, cred);
        Response bodyResponse = call.execute();
        String response = ((ResponseBody)bodyResponse.body()).string();
        System.out.println(response);
        if (response.startsWith("{")) {
            System.out.println("Delete Issue " + id + "=" + response);
        } else {
            System.out.println(response);
        }
    }
}

