/*
 * Decompiled with CFR 0.152.
 */
package com.geteasyqa.EasyQA.Issues;

import com.geteasyqa.EasyQA.API.GetNotRequiredParameters;
import com.geteasyqa.EasyQA.API.Initialization;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Response;

public class CreateIssue
extends Initialization {
    Integer id;

    public CreateIssue(String url) {
        super(url);
    }

    public Integer createIssue(String token, String auth_token, String summary, String description, String ... data) throws IOException, JSONException {
        Map<String, RequestBody> model = new GetNotRequiredParameters().getIntoMap("text/plain", data);
        model.put("token", RequestBody.create((MediaType)this.textType, (String)token));
        model.put("auth_token", RequestBody.create((MediaType)this.textType, (String)auth_token));
        model.put("summary", RequestBody.create((MediaType)this.textType, (String)summary));
        model.put("description", RequestBody.create((MediaType)this.textType, (String)description));
        Call<ResponseBody> call = this.easyqaUserAPI.uploadBugReport(model);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        System.out.println(result);
        if (result.startsWith("{")) {
            JSONObject jsonObj = new JSONObject(result);
            this.id = jsonObj.getInt("project_id");
        } else {
            System.out.println(result);
        }
        return this.id;
    }

    public Integer createIssueWithAttachments(String token, String auth_token, String summary, ArrayList<File> files, String description, String ... data) throws IOException, JSONException {
        Map<String, RequestBody> model = new GetNotRequiredParameters().getIntoMap("text/plain", data);
        model.put("token", RequestBody.create((MediaType)this.textType, (String)token));
        model.put("auth_token", RequestBody.create((MediaType)this.textType, (String)auth_token));
        model.put("summary", RequestBody.create((MediaType)this.textType, (String)summary));
        model.put("description", RequestBody.create((MediaType)this.textType, (String)description));
        for (File file : files) {
            String fileName = file.getName();
            model.put(String.format("%s\"; filename=\"%s", fileName, fileName), RequestBody.create((MediaType)(fileName.contains(".mp4") ? this.videoType : this.imageType), (File)file));
        }
        Call<ResponseBody> call = this.easyqaUserAPI.uploadBugReport(model);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        System.out.println(result);
        if (result.startsWith("{")) {
            JSONObject jsonObj = new JSONObject(result);
            this.id = jsonObj.getInt("project_issue_number");
            System.out.println("Create success! Issue id=" + this.id);
        } else {
            System.out.println(result);
        }
        return this.id;
    }

    public Integer createIssueFromDevice(String token, String summary, String deviceSerial, String deviceModel, String osVersion, String test_object_id, String ... data) throws IOException, JSONException {
        Map<String, RequestBody> model = new GetNotRequiredParameters().getIntoMap("text/plain", data);
        model.put("token", RequestBody.create((MediaType)this.textType, (String)token));
        model.put("summary", RequestBody.create((MediaType)this.textType, (String)summary));
        model.put("deviceSerial", RequestBody.create((MediaType)this.textType, (String)deviceSerial));
        model.put("deviceModel", RequestBody.create((MediaType)this.textType, (String)deviceModel));
        model.put("osVersion", RequestBody.create((MediaType)this.textType, (String)osVersion));
        model.put("test_object_id", RequestBody.create((MediaType)this.textType, (String)test_object_id));
        Call<ResponseBody> call = this.easyqaUserAPI.uploadBugReport(model);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        if (result.startsWith("{")) {
            JSONObject jsonObj = new JSONObject(result);
            this.id = jsonObj.getInt("project_issue_number");
        } else {
            System.out.println(result);
        }
        return this.id;
    }

    public Integer createIssueFromDeviceWithAttachment(String token, String summary, String deviceSerial, String deviceModel, String osVersion, String test_object_id, ArrayList<File> files, String ... data) throws IOException, JSONException {
        Map<String, RequestBody> model = new GetNotRequiredParameters().getIntoMap("text/plain", data);
        model.put("token", RequestBody.create((MediaType)this.textType, (String)token));
        model.put("summary", RequestBody.create((MediaType)this.textType, (String)summary));
        model.put("deviceSerial", RequestBody.create((MediaType)this.textType, (String)deviceSerial));
        model.put("deviceModel", RequestBody.create((MediaType)this.textType, (String)deviceModel));
        model.put("osVersion", RequestBody.create((MediaType)this.textType, (String)osVersion));
        model.put("test_object_id", RequestBody.create((MediaType)this.textType, (String)test_object_id));
        for (File file : files) {
            String fileName = file.getName();
            model.put(String.format("%s\"; filename=\"%s", fileName, fileName), RequestBody.create((MediaType)(fileName.contains(".mp4") ? this.videoType : this.imageType), (File)file));
        }
        Call<ResponseBody> call = this.easyqaUserAPI.uploadBugReport(model);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        JSONObject jsonObj = new JSONObject(result);
        System.out.println(result);
        this.id = jsonObj.getInt("project_issue_number");
        return this.id;
    }
}

