/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base.ssd;

import com.getbouncer.cardscan.base.ssd.DetectionBox;
import com.getbouncer.cardscan.base.ssd.NonMaximumSuppressionKt;
import com.getbouncer.cardscan.base.ssd.OcrFeatureMapSizes;
import com.getbouncer.cardscan.base.ssd.SSD;
import com.getbouncer.cardscan.base.ssd.Size;
import com.getbouncer.cardscan.base.ssd.domain.RectForm;
import com.getbouncer.cardscan.base.util.ArrayExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001am\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u00042\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\b0\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0011\u00a2\u0006\u0002\u0010\u0012\u001a7\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0019\u001a7\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0015\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"extractPredictions", "", "Lcom/getbouncer/cardscan/base/ssd/DetectionBox;", "scores", "", "", "Lcom/getbouncer/cardscan/base/ssd/domain/ClassifierScores;", "boxes", "Lcom/getbouncer/cardscan/base/ssd/domain/RectForm;", "imageSize", "Lcom/getbouncer/cardscan/base/ssd/Size;", "probabilityThreshold", "", "intersectionOverUnionThreshold", "limit", "", "classifierToLabel", "Lkotlin/Function1;", "([[F[[FLcom/getbouncer/cardscan/base/ssd/Size;FFLjava/lang/Integer;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "rearrangeArray", "locations", "featureMapSizes", "", "numberOfPriors", "locationsPerPrior", "([[F[III)[[F", "rearrangeOCRArray", "Lcom/getbouncer/cardscan/base/ssd/OcrFeatureMapSizes;", "([[FLcom/getbouncer/cardscan/base/ssd/OcrFeatureMapSizes;II)[[F", "cardscan-base_release"})
@JvmName(name="SSD")
public final class SSD {
    @NotNull
    public static final float[][] rearrangeOCRArray(@NotNull float[][] locations, @NotNull OcrFeatureMapSizes featureMapSizes, int numberOfPriors, int locationsPerPrior) {
        Intrinsics.checkParameterIsNotNull((Object)locations, (String)"locations");
        Intrinsics.checkParameterIsNotNull((Object)featureMapSizes, (String)"featureMapSizes");
        int totalLocationsForAllLayers = featureMapSizes.getLayerOneWidth() * featureMapSizes.getLayerOneHeight() * numberOfPriors * locationsPerPrior + featureMapSizes.getLayerTwoWidth() * featureMapSizes.getLayerTwoHeight() * numberOfPriors * locationsPerPrior;
        int n = 1;
        float[][] fArrayArray = new float[n][];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            int n4 = n2++;
            float[][] fArrayArray2 = fArrayArray;
            boolean bl = false;
            float[] fArray = new float[totalLocationsForAllLayers];
            fArrayArray2[n4] = fArray;
        }
        float[][] rearranged = fArrayArray;
        Object[] featureMapHeights = new Integer[]{featureMapSizes.getLayerOneHeight(), featureMapSizes.getLayerTwoHeight()};
        Object[] featureMapWidths = new Integer[]{featureMapSizes.getLayerOneWidth(), featureMapSizes.getLayerTwoWidth()};
        Iterator heightIterator = ArrayIteratorKt.iterator((Object[])featureMapHeights);
        Iterator widthIterator = ArrayIteratorKt.iterator((Object[])featureMapWidths);
        int offset = 0;
        while (heightIterator.hasNext() && widthIterator.hasNext()) {
            int height = ((Number)heightIterator.next()).intValue();
            int width = ((Number)widthIterator.next()).intValue();
            int totalNumberOfLocationsForThisLayer = height * width * numberOfPriors * locationsPerPrior;
            int stepsForLoop = height - 1;
            int j = 0;
            int i = 0;
            int step = 0;
            while (i < totalNumberOfLocationsForThisLayer) {
                while (step < height) {
                    for (j = step; j < totalNumberOfLocationsForThisLayer - stepsForLoop + step; j += height) {
                        rearranged[0][offset + i] = locations[0][offset + j];
                        ++i;
                    }
                    ++step;
                }
                offset += totalNumberOfLocationsForThisLayer;
            }
        }
        return rearranged;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final float[][] rearrangeArray(@NotNull float[][] locations, @NotNull int[] featureMapSizes, int numberOfPriors, int locationsPerPrior) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)locations, (String)"locations");
        Intrinsics.checkParameterIsNotNull((Object)featureMapSizes, (String)"featureMapSizes");
        int[] $this$map$iv = featureMapSizes;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var10_12 = $this$mapTo$iv$iv;
        int n = ((void)var10_12).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_17 = item$iv$iv = var10_12[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n2 = (int)(it * it * numberOfPriors * locationsPerPrior);
            collection.add(n2);
        }
        int totalLocationsForAllLayers = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
        float[] rearranged = new float[totalLocationsForAllLayers];
        int offset = 0;
        for (int steps : featureMapSizes) {
            int totalNumberOfLocationsForThisLayer = steps * steps * numberOfPriors * locationsPerPrior;
            int stepsForLoop = steps - 1;
            int j = 0;
            int i = 0;
            int step = 0;
            while (i < totalNumberOfLocationsForThisLayer) {
                while (step < steps) {
                    for (j = step; j < totalNumberOfLocationsForThisLayer - stepsForLoop + step; j += steps) {
                        rearranged[offset + i] = locations[0][offset + j];
                        ++i;
                    }
                    ++step;
                }
                offset += totalNumberOfLocationsForThisLayer;
            }
        }
        return new float[][]{rearranged};
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<DetectionBox> extractPredictions(@NotNull float[][] scores, @NotNull float[][] boxes, @NotNull Size imageSize, float probabilityThreshold, float intersectionOverUnionThreshold, @Nullable Integer limit, @NotNull Function1<? super Integer, Integer> classifierToLabel) {
        Intrinsics.checkParameterIsNotNull((Object)scores, (String)"scores");
        Intrinsics.checkParameterIsNotNull((Object)boxes, (String)"boxes");
        Intrinsics.checkParameterIsNotNull((Object)imageSize, (String)"imageSize");
        Intrinsics.checkParameterIsNotNull(classifierToLabel, (String)"classifierToLabel");
        boolean bl = false;
        List predictions = new ArrayList();
        float[][] classifiersScores = ArrayExtensions.transpose(scores);
        int n = 1;
        int n2 = ((Object[])classifiersScores).length;
        while (n < n2) {
            int[] filteredIndexes2;
            void classifier;
            float[] classifierScores = classifiersScores[classifier];
            int[] nArray = filteredIndexes2 = ArrayExtensions.filteredIndexes(classifierScores, (Function1<? super Float, Boolean>)((Function1)new Function1<Float, Boolean>(probabilityThreshold){
                final /* synthetic */ float $probabilityThreshold;

                public final boolean invoke(float it) {
                    return it >= this.$probabilityThreshold;
                }
                {
                    this.$probabilityThreshold = f;
                    super(1);
                }
            }));
            boolean bl2 = false;
            int[] nArray2 = nArray;
            boolean bl3 = false;
            if (!(nArray2.length == 0)) {
                float[] filteredScores = ArrayExtensions.filterByIndexes(classifierScores, filteredIndexes2);
                Object[] $this$filterByIndexes$iv = (Object[])boxes;
                boolean $i$f$filterByIndexes = false;
                int n3 = filteredIndexes2.length;
                float[][] fArrayArray = new float[n3][];
                int n4 = 0;
                while (n4 < n3) {
                    void it$iv;
                    int n5 = n4;
                    int n6 = n4++;
                    float[][] fArrayArray2 = fArrayArray;
                    boolean bl4 = false;
                    Object object = $this$filterByIndexes$iv[filteredIndexes2[it$iv]];
                    fArrayArray2[n6] = (float[])object;
                }
                float[][] filteredBoxes = fArrayArray;
                ArrayList<Integer> indexes = NonMaximumSuppressionKt.hardNonMaximumSuppression(filteredBoxes, filteredScores, intersectionOverUnionThreshold, limit);
                Iterator<Integer> iterator = indexes.iterator();
                while (iterator.hasNext()) {
                    Integer index;
                    Integer n7 = index = iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)n7, (String)"index");
                    predictions.add(new DetectionBox(RectForm.toRectF(filteredBoxes[n7]), imageSize, filteredScores[index], ((Number)classifierToLabel.invoke((Object)((int)classifier))).intValue()));
                }
            }
            ++classifier;
        }
        return predictions;
    }

    public static /* synthetic */ List extractPredictions$default(float[][] fArray, float[][] fArray2, Size size, float f, float f2, Integer n, Function1 function1, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            function1 = extractPredictions.1.INSTANCE;
        }
        return SSD.extractPredictions(fArray, fArray2, size, f, f2, n, (Function1<? super Integer, Integer>)function1);
    }
}

