/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public class ScanStats {
    private String flowName;
    private boolean mIsCameraPermissionGranted;
    private long endTimeMs;
    private long startTimeMs = SystemClock.uptimeMillis();
    private int scans = 0;
    private boolean success;
    private long panFirstDetectedAtMs = -1L;
    private int numOCRFramesProcessed = 0;
    private int numObjFramesProcessed = 0;

    ScanStats(boolean isCameraPermissionGranted, @NotNull String flowName) {
        this.mIsCameraPermissionGranted = isCameraPermissionGranted;
        this.flowName = flowName;
    }

    void incrementScans() {
        ++this.scans;
    }

    void setSuccess(boolean success) {
        this.success = success;
        this.endTimeMs = SystemClock.uptimeMillis();
    }

    void observePAN() {
        if (this.panFirstDetectedAtMs == -1L) {
            this.panFirstDetectedAtMs = SystemClock.uptimeMillis();
        }
    }

    public void processNumber() {
        ++this.numOCRFramesProcessed;
    }

    public void processObjectDetection() {
        ++this.numObjFramesProcessed;
    }

    @NonNull
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        double duration = ((double)this.endTimeMs - (double)this.startTimeMs) / 1000.0;
        long panFirstDetectedDurationMs = -1L;
        if (this.panFirstDetectedAtMs > 0L) {
            panFirstDetectedDurationMs = this.panFirstDetectedAtMs - this.startTimeMs;
        }
        try {
            object.put("success", this.success);
            object.put("scans", this.scans);
            object.put("torch_on", false);
            object.put("duration", duration);
            object.put("pan_first_detected_duration_ms", panFirstDetectedDurationMs);
            object.put("model", (Object)"FindFour");
            object.put("device_type", (Object)ScanStats.getDeviceName());
            object.put("sdk_version", (Object)"1.0.5145");
            object.put("os", (Object)Build.VERSION.RELEASE);
            object.put("permission_granted", this.mIsCameraPermissionGranted);
            object.put("flow_name", (Object)this.flowName);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object;
    }

    @NonNull
    private static String getDeviceName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return ScanStats.capitalize(model);
        }
        return ScanStats.capitalize(manufacturer) + " " + model;
    }

    @NonNull
    private static String capitalize(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        char[] arr = str.toCharArray();
        boolean capitalizeNext = true;
        StringBuilder phrase = new StringBuilder();
        for (char c : arr) {
            if (capitalizeNext && Character.isLetter(c)) {
                phrase.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            if (Character.isWhitespace(c)) {
                capitalizeNext = true;
            }
            phrase.append(c);
        }
        return phrase.toString();
    }
}

