/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Nullable;
import com.getbouncer.cardscan.base.OnCameraOpenListener;
import java.lang.ref.WeakReference;

class CameraThread
extends Thread {
    @Nullable
    private WeakReference<OnCameraOpenListener> mListener;

    CameraThread() {
    }

    synchronized void startCamera(OnCameraOpenListener listener) {
        this.mListener = new WeakReference<OnCameraOpenListener>(listener);
        this.notify();
    }

    @Nullable
    synchronized OnCameraOpenListener waitForOpenRequest() {
        while (this.mListener == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return (OnCameraOpenListener)this.mListener.get();
    }

    @Override
    public void run() {
        final OnCameraOpenListener listener = this.waitForOpenRequest();
        if (listener == null && this.mListener != null) {
            this.mListener.clear();
            return;
        }
        Camera camera = null;
        try {
            camera = Camera.open();
        }
        catch (Exception e) {
            Log.e((String)"CameraThread", (String)"failed to open Camera");
            e.printStackTrace();
        }
        final Camera resultCamera = camera;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    listener.onCameraOpen(resultCamera);
                }
                if (CameraThread.this.mListener != null) {
                    CameraThread.this.mListener.clear();
                }
                CameraThread.this.mListener = null;
            }
        });
    }
}

