/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base.ssd;

import android.graphics.RectF;
import org.json.JSONException;
import org.json.JSONObject;

public class DetectedSSDBox {
    float XMin;
    float YMin;
    float XMax;
    float YMax;
    public float confidence;
    public int label;
    int imageWidth;
    int imageHeight;
    public RectF rect;

    public DetectedSSDBox(float XMin, float YMin, float XMax, float YMax, float confidence, int imageWidth, int imageHeight, int label) {
        this.XMin = XMin * (float)imageWidth;
        this.XMax = XMax * (float)imageWidth;
        this.YMin = YMin * (float)imageHeight;
        this.YMax = YMax * (float)imageHeight;
        this.confidence = confidence;
        this.label = label;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.rect = new RectF(this.XMin, this.YMin, this.XMax, this.YMax);
    }

    public JSONObject toJson() {
        try {
            JSONObject result = new JSONObject();
            result.put("x_min", (double)(this.XMin / (float)this.imageWidth));
            result.put("y_min", (double)(this.YMin / (float)this.imageHeight));
            result.put("width", (double)((this.XMax - this.XMin) / (float)this.imageWidth));
            result.put("height", (double)((this.YMax - this.YMin) / (float)this.imageHeight));
            result.put("label", this.label);
            result.put("confidence", (double)this.confidence);
            return result;
        }
        catch (JSONException je) {
            je.printStackTrace();
            return new JSONObject();
        }
    }
}

