/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;

class ScanStats {
    private long endTimeMs;
    private long startTimeMs = SystemClock.uptimeMillis();
    private int scans = 0;
    private boolean success;

    ScanStats() {
    }

    void incrementScans() {
        ++this.scans;
    }

    void setSuccess(boolean success) {
        this.success = success;
        this.endTimeMs = SystemClock.uptimeMillis();
    }

    JSONObject toJson() {
        JSONObject object = new JSONObject();
        double duration = ((double)this.endTimeMs - (double)this.startTimeMs) / 1000.0;
        try {
            object.put("success", this.success);
            object.put("scans", this.scans);
            object.put("torch_on", false);
            object.put("duration", duration);
            object.put("model", (Object)"FindFour");
            object.put("device_type", (Object)ScanStats.getDeviceName());
            object.put("sdk_version", (Object)"1.0.5113");
            object.put("os", (Object)Build.VERSION.RELEASE);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object;
    }

    private static String getDeviceName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return ScanStats.capitalize(model);
        }
        return ScanStats.capitalize(manufacturer) + " " + model;
    }

    private static String capitalize(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        char[] arr = str.toCharArray();
        boolean capitalizeNext = true;
        StringBuilder phrase = new StringBuilder();
        for (char c : arr) {
            if (capitalizeNext && Character.isLetter(c)) {
                phrase.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            if (Character.isWhitespace(c)) {
                capitalizeNext = true;
            }
            phrase.append(c);
        }
        return phrase.toString();
    }
}

