/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import com.getbouncer.cardscan.base.R;

class Overlay
extends View {
    private RectF rect;
    private RectF oval = new RectF();
    private int radius;
    private final Xfermode xfermode = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
    int cornerDp = 6;
    boolean drawCorners = true;

    public Overlay(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setLayerType(1, null);
    }

    protected int getBackgroundColorId() {
        return R.color.card_scan_camera_background;
    }

    protected int getCornerColorId() {
        return R.color.card_scan_corner_color;
    }

    public void setCircle(RectF rect, int radius) {
        this.rect = rect;
        this.radius = radius;
        this.postInvalidate();
    }

    private int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.rect != null) {
            Paint paintAntiAlias = new Paint(1);
            paintAntiAlias.setColor(this.getResources().getColor(this.getBackgroundColorId()));
            paintAntiAlias.setStyle(Paint.Style.FILL);
            canvas.drawPaint(paintAntiAlias);
            paintAntiAlias.setXfermode(this.xfermode);
            canvas.drawRoundRect(this.rect, (float)this.radius, (float)this.radius, paintAntiAlias);
            if (!this.drawCorners) {
                return;
            }
            Paint paint = new Paint();
            paint.setColor(this.getResources().getColor(this.getCornerColorId()));
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth((float)this.dpToPx(this.cornerDp));
            int lineLength = this.dpToPx(20);
            float x = this.rect.left - (float)this.dpToPx(1);
            float y = this.rect.top - (float)this.dpToPx(1);
            this.oval.left = x;
            this.oval.top = y;
            this.oval.right = x + (float)(2 * this.radius);
            this.oval.bottom = y + (float)(2 * this.radius);
            canvas.drawArc(this.oval, 180.0f, 90.0f, false, paint);
            canvas.drawLine(this.oval.left, this.oval.bottom - (float)this.radius, this.oval.left, this.oval.bottom - (float)this.radius + (float)lineLength, paint);
            canvas.drawLine(this.oval.right - (float)this.radius, this.oval.top, this.oval.right - (float)this.radius + (float)lineLength, this.oval.top, paint);
            x = this.rect.right + (float)this.dpToPx(1) - (float)(2 * this.radius);
            y = this.rect.top - (float)this.dpToPx(1);
            this.oval.left = x;
            this.oval.top = y;
            this.oval.right = x + (float)(2 * this.radius);
            this.oval.bottom = y + (float)(2 * this.radius);
            canvas.drawArc(this.oval, 270.0f, 90.0f, false, paint);
            canvas.drawLine(this.oval.right, this.oval.bottom - (float)this.radius, this.oval.right, this.oval.bottom - (float)this.radius + (float)lineLength, paint);
            canvas.drawLine(this.oval.right - (float)this.radius, this.oval.top, this.oval.right - (float)this.radius - (float)lineLength, this.oval.top, paint);
            x = this.rect.right + (float)this.dpToPx(1) - (float)(2 * this.radius);
            y = this.rect.bottom + (float)this.dpToPx(1) - (float)(2 * this.radius);
            this.oval.left = x;
            this.oval.top = y;
            this.oval.right = x + (float)(2 * this.radius);
            this.oval.bottom = y + (float)(2 * this.radius);
            canvas.drawArc(this.oval, 0.0f, 90.0f, false, paint);
            canvas.drawLine(this.oval.right, this.oval.bottom - (float)this.radius, this.oval.right, this.oval.bottom - (float)this.radius - (float)lineLength, paint);
            canvas.drawLine(this.oval.right - (float)this.radius, this.oval.bottom, this.oval.right - (float)this.radius - (float)lineLength, this.oval.bottom, paint);
            x = this.rect.left - (float)this.dpToPx(1);
            y = this.rect.bottom + (float)this.dpToPx(1) - (float)(2 * this.radius);
            this.oval.left = x;
            this.oval.top = y;
            this.oval.right = x + (float)(2 * this.radius);
            this.oval.bottom = y + (float)(2 * this.radius);
            canvas.drawArc(this.oval, 90.0f, 90.0f, false, paint);
            canvas.drawLine(this.oval.left, this.oval.bottom - (float)this.radius, this.oval.left, this.oval.bottom - (float)this.radius - (float)lineLength, paint);
            canvas.drawLine(this.oval.right - (float)this.radius, this.oval.bottom, this.oval.right - (float)this.radius + (float)lineLength, this.oval.bottom, paint);
        }
    }
}

