/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.floatingactionbutton;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.TextView;
import com.getbase.floatingactionbutton.AddFloatingActionButton;
import com.getbase.floatingactionbutton.FloatingActionButton;
import com.getbase.floatingactionbutton.R;

public class FloatingActionsMenu
extends ViewGroup {
    public static final int EXPAND_UP = 0;
    public static final int EXPAND_DOWN = 1;
    public static final int EXPAND_LEFT = 2;
    public static final int EXPAND_RIGHT = 3;
    private static final int ANIMATION_DURATION = 300;
    private static final float COLLAPSED_PLUS_ROTATION = 0.0f;
    private static final float EXPANDED_PLUS_ROTATION = 135.0f;
    private int mAddButtonPlusColor;
    private int mAddButtonColorNormal;
    private int mAddButtonColorPressed;
    private int mExpandDirection;
    private int mButtonSpacing;
    private int mLabelsMargin;
    private int mLabelsVerticalOffset;
    private boolean mExpanded;
    private AnimatorSet mExpandAnimation = new AnimatorSet().setDuration(300L);
    private AnimatorSet mCollapseAnimation = new AnimatorSet().setDuration(300L);
    private AddFloatingActionButton mAddButton;
    private RotatingDrawable mRotatingDrawable;
    private int mLabelsStyle;
    private int mButtonsCount;
    private static Interpolator sExpandInterpolator = new OvershootInterpolator();
    private static Interpolator sCollapseInterpolator = new DecelerateInterpolator(3.0f);
    private static Interpolator sAlphaExpandInterpolator = new DecelerateInterpolator();

    public FloatingActionsMenu(Context context) {
        this(context, null);
    }

    public FloatingActionsMenu(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FloatingActionsMenu(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.mButtonSpacing = (int)(this.getResources().getDimension(R.dimen.fab_actions_spacing) - this.getResources().getDimension(R.dimen.fab_shadow_radius) - this.getResources().getDimension(R.dimen.fab_shadow_offset));
        this.mLabelsMargin = this.getResources().getDimensionPixelSize(R.dimen.fab_labels_margin);
        this.mLabelsVerticalOffset = this.getResources().getDimensionPixelSize(R.dimen.fab_shadow_offset);
        TypedArray attr = context.obtainStyledAttributes(attributeSet, R.styleable.FloatingActionsMenu, 0, 0);
        this.mAddButtonPlusColor = attr.getColor(2, this.getColor(17170443));
        this.mAddButtonColorNormal = attr.getColor(1, this.getColor(17170451));
        this.mAddButtonColorPressed = attr.getColor(0, this.getColor(17170450));
        this.mExpandDirection = attr.getInt(4, 0);
        this.mLabelsStyle = attr.getResourceId(3, 0);
        attr.recycle();
        if (this.mLabelsStyle != 0 && this.expandsHorizontally()) {
            throw new IllegalStateException("Action labels in horizontal expand orientation is not supported.");
        }
        this.createAddButton(context);
    }

    private boolean expandsHorizontally() {
        return this.mExpandDirection == 2 || this.mExpandDirection == 3;
    }

    private void createAddButton(Context context) {
        this.mAddButton = new AddFloatingActionButton(context){

            @Override
            void updateBackground() {
                this.mPlusColor = FloatingActionsMenu.this.mAddButtonPlusColor;
                this.mColorNormal = FloatingActionsMenu.this.mAddButtonColorNormal;
                this.mColorPressed = FloatingActionsMenu.this.mAddButtonColorPressed;
                super.updateBackground();
            }

            @Override
            Drawable getIconDrawable() {
                RotatingDrawable rotatingDrawable = new RotatingDrawable(super.getIconDrawable());
                FloatingActionsMenu.this.mRotatingDrawable = rotatingDrawable;
                OvershootInterpolator interpolator = new OvershootInterpolator();
                ObjectAnimator collapseAnimator = ObjectAnimator.ofFloat((Object)((Object)rotatingDrawable), (String)"rotation", (float[])new float[]{135.0f, 0.0f});
                ObjectAnimator expandAnimator = ObjectAnimator.ofFloat((Object)((Object)rotatingDrawable), (String)"rotation", (float[])new float[]{0.0f, 135.0f});
                collapseAnimator.setInterpolator((TimeInterpolator)interpolator);
                expandAnimator.setInterpolator((TimeInterpolator)interpolator);
                FloatingActionsMenu.this.mExpandAnimation.play((Animator)expandAnimator);
                FloatingActionsMenu.this.mCollapseAnimation.play((Animator)collapseAnimator);
                return rotatingDrawable;
            }
        };
        this.mAddButton.setId(R.id.fab_expand_menu_button);
        this.mAddButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingActionsMenu.this.toggle();
            }
        });
        this.addView((View)this.mAddButton, super.generateDefaultLayoutParams());
    }

    public void addButton(FloatingActionButton button) {
        this.addView((View)button, this.mButtonsCount - 1);
        ++this.mButtonsCount;
        if (this.mLabelsStyle != 0) {
            this.createLabels();
        }
    }

    private int getColor(int id2) {
        return this.getResources().getColor(id2);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int width = 0;
        int height = 0;
        int maxLabelWidth = 0;
        for (int i = 0; i < this.mButtonsCount; ++i) {
            TextView label;
            View child = this.getChildAt(i);
            switch (this.mExpandDirection) {
                case 0: 
                case 1: {
                    width = Math.max(width, child.getMeasuredWidth());
                    height += child.getMeasuredHeight();
                    break;
                }
                case 2: 
                case 3: {
                    width += child.getMeasuredWidth();
                    height = Math.max(height, child.getMeasuredHeight());
                }
            }
            if (this.expandsHorizontally() || (label = (TextView)child.getTag(R.id.fab_label)) == null) continue;
            maxLabelWidth = Math.max(maxLabelWidth, label.getMeasuredWidth());
        }
        if (!this.expandsHorizontally()) {
            width += maxLabelWidth + this.mLabelsMargin;
        }
        switch (this.mExpandDirection) {
            case 0: 
            case 1: {
                height += this.mButtonSpacing * (this.getChildCount() - 1);
                height = this.adjustForOvershoot(height);
                break;
            }
            case 2: 
            case 3: {
                width += this.mButtonSpacing * (this.getChildCount() - 1);
                width = this.adjustForOvershoot(width);
            }
        }
        this.setMeasuredDimension(width, height);
    }

    private int adjustForOvershoot(int dimension) {
        return dimension * 12 / 10;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        switch (this.mExpandDirection) {
            case 0: 
            case 1: {
                boolean expandUp = this.mExpandDirection == 0;
                int addButtonY = expandUp ? b - t - this.mAddButton.getMeasuredHeight() : 0;
                int addButtonLeft = r - l - this.mAddButton.getMeasuredWidth();
                this.mAddButton.layout(addButtonLeft, addButtonY, addButtonLeft + this.mAddButton.getMeasuredWidth(), addButtonY + this.mAddButton.getMeasuredHeight());
                int labelsRight = addButtonLeft - this.mLabelsMargin;
                int nextY = expandUp ? addButtonY - this.mButtonSpacing : addButtonY + this.mAddButton.getMeasuredHeight() + this.mButtonSpacing;
                for (int i = this.mButtonsCount - 1; i >= 0; --i) {
                    View child = this.getChildAt(i);
                    if (child == this.mAddButton) continue;
                    int childX = addButtonLeft + (this.mAddButton.getMeasuredWidth() - child.getMeasuredWidth()) / 2;
                    int childY = expandUp ? nextY - child.getMeasuredHeight() : nextY;
                    child.layout(childX, childY, childX + child.getMeasuredWidth(), childY + child.getMeasuredHeight());
                    float collapsedTranslation = addButtonY - childY;
                    float expandedTranslation = 0.0f;
                    child.setTranslationY(this.mExpanded ? expandedTranslation : collapsedTranslation);
                    child.setAlpha(this.mExpanded ? 1.0f : 0.0f);
                    LayoutParams params = (LayoutParams)child.getLayoutParams();
                    params.mCollapseDir.setFloatValues(new float[]{expandedTranslation, collapsedTranslation});
                    params.mExpandDir.setFloatValues(new float[]{collapsedTranslation, expandedTranslation});
                    params.setAnimationsTarget(child);
                    View label = (View)child.getTag(R.id.fab_label);
                    if (label != null) {
                        int labelLeft = labelsRight - label.getMeasuredWidth();
                        int labelTop = childY - this.mLabelsVerticalOffset + (child.getMeasuredHeight() - label.getMeasuredHeight()) / 2;
                        label.layout(labelLeft, labelTop, labelsRight, labelTop + label.getMeasuredHeight());
                        label.setTranslationY(this.mExpanded ? expandedTranslation : collapsedTranslation);
                        label.setAlpha(this.mExpanded ? 1.0f : 0.0f);
                        LayoutParams labelParams = (LayoutParams)label.getLayoutParams();
                        labelParams.mCollapseDir.setFloatValues(new float[]{expandedTranslation, collapsedTranslation});
                        labelParams.mExpandDir.setFloatValues(new float[]{collapsedTranslation, expandedTranslation});
                        labelParams.setAnimationsTarget(label);
                    }
                    nextY = expandUp ? childY - this.mButtonSpacing : childY + child.getMeasuredHeight() + this.mButtonSpacing;
                }
                break;
            }
            case 2: 
            case 3: {
                boolean expandLeft = this.mExpandDirection == 2;
                int addButtonX = expandLeft ? r - l - this.mAddButton.getMeasuredWidth() : 0;
                this.mAddButton.layout(addButtonX, 0, addButtonX + this.mAddButton.getMeasuredWidth(), this.mAddButton.getMeasuredHeight());
                int nextX = expandLeft ? addButtonX - this.mButtonSpacing : addButtonX + this.mAddButton.getMeasuredWidth() + this.mButtonSpacing;
                for (int i = this.mButtonsCount - 1; i >= 0; --i) {
                    View child = this.getChildAt(i);
                    if (child == this.mAddButton) continue;
                    int childX = expandLeft ? nextX - child.getMeasuredWidth() : nextX;
                    int childY = (this.mAddButton.getMeasuredHeight() - child.getMeasuredHeight()) / 2;
                    child.layout(childX, childY, childX + child.getMeasuredWidth(), childY + child.getMeasuredHeight());
                    float collapsedTranslation = addButtonX - childX;
                    float expandedTranslation = 0.0f;
                    child.setTranslationX(this.mExpanded ? expandedTranslation : collapsedTranslation);
                    child.setAlpha(this.mExpanded ? 1.0f : 0.0f);
                    LayoutParams params = (LayoutParams)child.getLayoutParams();
                    params.mCollapseDir.setFloatValues(new float[]{expandedTranslation, collapsedTranslation});
                    params.mExpandDir.setFloatValues(new float[]{collapsedTranslation, expandedTranslation});
                    params.setAnimationsTarget(child);
                    nextX = expandLeft ? childX - this.mButtonSpacing : childX + child.getMeasuredWidth() + this.mButtonSpacing;
                }
                break;
            }
        }
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(super.generateDefaultLayoutParams());
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(super.generateLayoutParams(attrs));
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(super.generateLayoutParams(p));
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return super.checkLayoutParams(p);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bringChildToFront((View)this.mAddButton);
        this.mButtonsCount = this.getChildCount();
        if (this.mLabelsStyle != 0) {
            this.createLabels();
        }
    }

    private void createLabels() {
        ContextThemeWrapper context = new ContextThemeWrapper(this.getContext(), this.mLabelsStyle);
        for (int i = 0; i < this.mButtonsCount; ++i) {
            FloatingActionButton button = (FloatingActionButton)this.getChildAt(i);
            String title = button.getTitle();
            if (button == this.mAddButton || title == null || button.getTag(R.id.fab_label) != null) continue;
            TextView label = new TextView((Context)context);
            label.setText((CharSequence)button.getTitle());
            this.addView((View)label);
            button.setTag(R.id.fab_label, label);
        }
    }

    public void collapse() {
        if (this.mExpanded) {
            this.mExpanded = false;
            this.mCollapseAnimation.start();
            this.mExpandAnimation.cancel();
        }
    }

    public void toggle() {
        if (this.mExpanded) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    public void expand() {
        if (!this.mExpanded) {
            this.mExpanded = true;
            this.mCollapseAnimation.cancel();
            this.mExpandAnimation.start();
        }
    }

    public boolean isExpanded() {
        return this.mExpanded;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.mExpanded = this.mExpanded;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState savedState = (SavedState)state;
            this.mExpanded = savedState.mExpanded;
            if (this.mRotatingDrawable != null) {
                this.mRotatingDrawable.setRotation(this.mExpanded ? 135.0f : 0.0f);
            }
            super.onRestoreInstanceState(savedState.getSuperState());
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public boolean mExpanded;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable parcel) {
            super(parcel);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mExpanded = in.readInt() == 1;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mExpanded ? 1 : 0);
        }
    }

    private class LayoutParams
    extends ViewGroup.LayoutParams {
        private ObjectAnimator mExpandDir;
        private ObjectAnimator mExpandAlpha;
        private ObjectAnimator mCollapseDir;
        private ObjectAnimator mCollapseAlpha;

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
            this.mExpandDir = new ObjectAnimator();
            this.mExpandAlpha = new ObjectAnimator();
            this.mCollapseDir = new ObjectAnimator();
            this.mCollapseAlpha = new ObjectAnimator();
            this.mExpandDir.setInterpolator((TimeInterpolator)sExpandInterpolator);
            this.mExpandAlpha.setInterpolator((TimeInterpolator)sAlphaExpandInterpolator);
            this.mCollapseDir.setInterpolator((TimeInterpolator)sCollapseInterpolator);
            this.mCollapseAlpha.setInterpolator((TimeInterpolator)sCollapseInterpolator);
            this.mCollapseAlpha.setProperty(View.ALPHA);
            this.mCollapseAlpha.setFloatValues(new float[]{1.0f, 0.0f});
            this.mExpandAlpha.setProperty(View.ALPHA);
            this.mExpandAlpha.setFloatValues(new float[]{0.0f, 1.0f});
            switch (FloatingActionsMenu.this.mExpandDirection) {
                case 0: 
                case 1: {
                    this.mCollapseDir.setProperty(View.TRANSLATION_Y);
                    this.mExpandDir.setProperty(View.TRANSLATION_Y);
                    break;
                }
                case 2: 
                case 3: {
                    this.mCollapseDir.setProperty(View.TRANSLATION_X);
                    this.mExpandDir.setProperty(View.TRANSLATION_X);
                }
            }
            FloatingActionsMenu.this.mExpandAnimation.play((Animator)this.mExpandAlpha);
            FloatingActionsMenu.this.mExpandAnimation.play((Animator)this.mExpandDir);
            FloatingActionsMenu.this.mCollapseAnimation.play((Animator)this.mCollapseAlpha);
            FloatingActionsMenu.this.mCollapseAnimation.play((Animator)this.mCollapseDir);
        }

        public void setAnimationsTarget(View view) {
            this.mCollapseAlpha.setTarget((Object)view);
            this.mCollapseDir.setTarget((Object)view);
            this.mExpandAlpha.setTarget((Object)view);
            this.mExpandDir.setTarget((Object)view);
        }
    }

    private static class RotatingDrawable
    extends LayerDrawable {
        private float mRotation;

        public RotatingDrawable(Drawable drawable2) {
            super(new Drawable[]{drawable2});
        }

        public float getRotation() {
            return this.mRotation;
        }

        public void setRotation(float rotation) {
            this.mRotation = rotation;
            this.invalidateSelf();
        }

        public void draw(Canvas canvas) {
            canvas.save();
            canvas.rotate(this.mRotation, (float)this.getBounds().centerX(), (float)this.getBounds().centerY());
            super.draw(canvas);
            canvas.restore();
        }
    }
}

