/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.floatingactionbutton;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.TextView;
import com.getbase.floatingactionbutton.AddFloatingActionButton;
import com.getbase.floatingactionbutton.FloatingActionButton;
import com.getbase.floatingactionbutton.R;
import com.getbase.floatingactionbutton.TouchDelegateGroup;

public class FloatingActionsMenu
extends ViewGroup {
    public static final int EXPAND_UP = 0;
    public static final int EXPAND_DOWN = 1;
    public static final int EXPAND_LEFT = 2;
    public static final int EXPAND_RIGHT = 3;
    public static final int LABELS_ON_LEFT_SIDE = 0;
    public static final int LABELS_ON_RIGHT_SIDE = 1;
    private static final int ANIMATION_DURATION = 300;
    private static final float COLLAPSED_PLUS_ROTATION = 0.0f;
    private static final float EXPANDED_PLUS_ROTATION = 135.0f;
    private int mAddButtonPlusColor;
    private int mAddButtonColorNormal;
    private int mAddButtonColorPressed;
    private int mAddButtonSize;
    private boolean mAddButtonStrokeVisible;
    private int mAddButtonIcon;
    private int mAddButtonIconPressed;
    private int mExpandDirection;
    private int mButtonSpacing;
    private int mLabelsMargin;
    private int mLabelsVerticalOffset;
    private boolean mExpanded;
    private AnimatorSet mExpandAnimation = new AnimatorSet().setDuration(300L);
    private AnimatorSet mCollapseAnimation = new AnimatorSet().setDuration(300L);
    private FloatingActionButton mAddButton;
    private AnimatingDrawable mAnimatingDrawable;
    private int mMaxButtonWidth;
    private int mMaxButtonHeight;
    private int mLabelsStyle;
    private int mLabelsPosition;
    private int mButtonsCount;
    private TouchDelegateGroup mTouchDelegateGroup;
    private OnFloatingActionsMenuUpdateListener mListener;
    private static Interpolator sExpandInterpolator = new OvershootInterpolator();
    private static Interpolator sCollapseInterpolator = new DecelerateInterpolator(3.0f);
    private static Interpolator sAlphaExpandInterpolator = new DecelerateInterpolator();

    public FloatingActionsMenu(Context context) {
        this(context, null);
    }

    public FloatingActionsMenu(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FloatingActionsMenu(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.mButtonSpacing = (int)(this.getResources().getDimension(R.dimen.fab_actions_spacing) - this.getResources().getDimension(R.dimen.fab_shadow_radius) - this.getResources().getDimension(R.dimen.fab_shadow_offset));
        this.mLabelsMargin = this.getResources().getDimensionPixelSize(R.dimen.fab_labels_margin);
        this.mLabelsVerticalOffset = this.getResources().getDimensionPixelSize(R.dimen.fab_shadow_offset);
        this.mTouchDelegateGroup = new TouchDelegateGroup((View)this);
        this.setTouchDelegate(this.mTouchDelegateGroup);
        TypedArray attr2 = context.obtainStyledAttributes(attributeSet, R.styleable.FloatingActionsMenu, 0, 0);
        this.mAddButtonPlusColor = attr2.getColor(R.styleable.FloatingActionsMenu_fab_addButtonPlusIconColor, this.getColor(17170443));
        this.mAddButtonColorNormal = attr2.getColor(R.styleable.FloatingActionsMenu_fab_addButtonColorNormal, this.getColor(17170451));
        this.mAddButtonColorPressed = attr2.getColor(R.styleable.FloatingActionsMenu_fab_addButtonColorPressed, this.getColor(17170450));
        this.mAddButtonSize = attr2.getInt(R.styleable.FloatingActionsMenu_fab_addButtonSize, 0);
        this.mAddButtonStrokeVisible = attr2.getBoolean(R.styleable.FloatingActionsMenu_fab_addButtonStrokeVisible, true);
        this.mAddButtonIcon = attr2.getResourceId(R.styleable.FloatingActionsMenu_fab_addButtonIcon, 0);
        this.mAddButtonIconPressed = attr2.getResourceId(R.styleable.FloatingActionsMenu_fab_addButtonIconPressed, 0);
        this.mExpandDirection = attr2.getInt(R.styleable.FloatingActionsMenu_fab_expandDirection, 0);
        this.mLabelsStyle = attr2.getResourceId(R.styleable.FloatingActionsMenu_fab_labelStyle, 0);
        this.mLabelsPosition = attr2.getInt(R.styleable.FloatingActionsMenu_fab_labelsPosition, 0);
        attr2.recycle();
        if (this.mLabelsStyle != 0 && this.expandsHorizontally()) {
            throw new IllegalStateException("Action labels in horizontal expand orientation is not supported.");
        }
        this.createAddButton(context);
    }

    public void setOnFloatingActionsMenuUpdateListener(OnFloatingActionsMenuUpdateListener listener) {
        this.mListener = listener;
    }

    private boolean expandsHorizontally() {
        return this.mExpandDirection == 2 || this.mExpandDirection == 3;
    }

    private void createAddButton(final Context context) {
        this.mAddButton = this.mAddButtonIcon != 0 ? new FloatingActionButton(context){

            @Override
            void updateBackground() {
                this.mColorNormal = FloatingActionsMenu.this.mAddButtonColorNormal;
                this.mColorPressed = FloatingActionsMenu.this.mAddButtonColorPressed;
                this.mStrokeVisible = FloatingActionsMenu.this.mAddButtonStrokeVisible;
                super.updateBackground();
            }

            @Override
            Drawable getIconDrawable() {
                Resources res = context.getResources();
                SwitchingDrawable drawable2 = FloatingActionsMenu.this.mAddButtonIconPressed != 0 ? new SwitchingDrawable(res.getDrawable(FloatingActionsMenu.this.mAddButtonIcon), res.getDrawable(FloatingActionsMenu.this.mAddButtonIconPressed)) : new SwitchingDrawable(res.getDrawable(FloatingActionsMenu.this.mAddButtonIcon));
                FloatingActionsMenu.this.mAnimatingDrawable = drawable2;
                FloatingActionsMenu.this.setUpIconAnimation(drawable2);
                return drawable2;
            }
        } : new AddFloatingActionButton(context){

            @Override
            void updateBackground() {
                this.mPlusColor = FloatingActionsMenu.this.mAddButtonPlusColor;
                this.mColorNormal = FloatingActionsMenu.this.mAddButtonColorNormal;
                this.mColorPressed = FloatingActionsMenu.this.mAddButtonColorPressed;
                this.mStrokeVisible = FloatingActionsMenu.this.mAddButtonStrokeVisible;
                super.updateBackground();
            }

            @Override
            Drawable getIconDrawable() {
                RotatingDrawable rotatingDrawable = new RotatingDrawable(super.getIconDrawable(), 0.0f, 135.0f);
                FloatingActionsMenu.this.mAnimatingDrawable = rotatingDrawable;
                FloatingActionsMenu.this.setUpIconAnimation(rotatingDrawable);
                return rotatingDrawable;
            }
        };
        this.mAddButton.setId(R.id.fab_expand_menu_button);
        this.mAddButton.setSize(this.mAddButtonSize);
        this.mAddButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingActionsMenu.this.toggle();
            }
        });
        this.addView((View)this.mAddButton, super.generateDefaultLayoutParams());
        ++this.mButtonsCount;
    }

    private void setUpIconAnimation(AnimatingDrawable animatingDrawable) {
        OvershootInterpolator interpolator = new OvershootInterpolator();
        ObjectAnimator collapseAnimator = ObjectAnimator.ofFloat((Object)((Object)animatingDrawable), (String)"progress", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator expandAnimator = ObjectAnimator.ofFloat((Object)((Object)animatingDrawable), (String)"progress", (float[])new float[]{0.0f, 1.0f});
        collapseAnimator.setInterpolator((TimeInterpolator)interpolator);
        expandAnimator.setInterpolator((TimeInterpolator)interpolator);
        this.mExpandAnimation.play((Animator)expandAnimator);
        this.mCollapseAnimation.play((Animator)collapseAnimator);
    }

    public void addButton(FloatingActionButton button) {
        this.addView((View)button, this.mButtonsCount - 1);
        ++this.mButtonsCount;
        if (this.mLabelsStyle != 0) {
            this.createLabels();
        }
    }

    public void removeButton(FloatingActionButton button) {
        this.removeView((View)button.getLabelView());
        this.removeView((View)button);
        button.setTag(R.id.fab_label, null);
        --this.mButtonsCount;
    }

    private int getColor(@ColorRes int id2) {
        return this.getResources().getColor(id2);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int width = 0;
        int height = 0;
        this.mMaxButtonWidth = 0;
        this.mMaxButtonHeight = 0;
        int maxLabelWidth = 0;
        for (int i = 0; i < this.mButtonsCount; ++i) {
            TextView label;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            switch (this.mExpandDirection) {
                case 0: 
                case 1: {
                    this.mMaxButtonWidth = Math.max(this.mMaxButtonWidth, child.getMeasuredWidth());
                    height += child.getMeasuredHeight();
                    break;
                }
                case 2: 
                case 3: {
                    width += child.getMeasuredWidth();
                    this.mMaxButtonHeight = Math.max(this.mMaxButtonHeight, child.getMeasuredHeight());
                }
            }
            if (this.expandsHorizontally() || (label = (TextView)child.getTag(R.id.fab_label)) == null) continue;
            maxLabelWidth = Math.max(maxLabelWidth, label.getMeasuredWidth());
        }
        if (!this.expandsHorizontally()) {
            width = this.mMaxButtonWidth + (maxLabelWidth > 0 ? maxLabelWidth + this.mLabelsMargin : 0);
        } else {
            height = this.mMaxButtonHeight;
        }
        switch (this.mExpandDirection) {
            case 0: 
            case 1: {
                height += this.mButtonSpacing * (this.mButtonsCount - 1);
                height = this.adjustForOvershoot(height);
                break;
            }
            case 2: 
            case 3: {
                width += this.mButtonSpacing * (this.mButtonsCount - 1);
                width = this.adjustForOvershoot(width);
            }
        }
        this.setMeasuredDimension(width, height);
    }

    private int adjustForOvershoot(int dimension) {
        return dimension * 12 / 10;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        switch (this.mExpandDirection) {
            case 0: 
            case 1: {
                boolean expandUp;
                boolean bl = expandUp = this.mExpandDirection == 0;
                if (changed) {
                    this.mTouchDelegateGroup.clearTouchDelegates();
                }
                int addButtonY = expandUp ? b - t - this.mAddButton.getMeasuredHeight() : 0;
                int buttonsHorizontalCenter = this.mLabelsPosition == 0 ? r - l - this.mMaxButtonWidth / 2 : this.mMaxButtonWidth / 2;
                int addButtonLeft = buttonsHorizontalCenter - this.mAddButton.getMeasuredWidth() / 2;
                this.mAddButton.layout(addButtonLeft, addButtonY, addButtonLeft + this.mAddButton.getMeasuredWidth(), addButtonY + this.mAddButton.getMeasuredHeight());
                int labelsOffset = this.mMaxButtonWidth / 2 + this.mLabelsMargin;
                int labelsXNearButton = this.mLabelsPosition == 0 ? buttonsHorizontalCenter - labelsOffset : buttonsHorizontalCenter + labelsOffset;
                int nextY = expandUp ? addButtonY - this.mButtonSpacing : addButtonY + this.mAddButton.getMeasuredHeight() + this.mButtonSpacing;
                for (int i = this.mButtonsCount - 1; i >= 0; --i) {
                    View child = this.getChildAt(i);
                    if (child == this.mAddButton || child.getVisibility() == 8) continue;
                    int childX = buttonsHorizontalCenter - child.getMeasuredWidth() / 2;
                    int childY = expandUp ? nextY - child.getMeasuredHeight() : nextY;
                    child.layout(childX, childY, childX + child.getMeasuredWidth(), childY + child.getMeasuredHeight());
                    float collapsedTranslation = addButtonY - childY;
                    float expandedTranslation = 0.0f;
                    child.setTranslationY(this.mExpanded ? expandedTranslation : collapsedTranslation);
                    child.setAlpha(this.mExpanded ? 1.0f : 0.0f);
                    LayoutParams params = (LayoutParams)child.getLayoutParams();
                    params.mCollapseDir.setFloatValues(new float[]{expandedTranslation, collapsedTranslation});
                    params.mExpandDir.setFloatValues(new float[]{collapsedTranslation, expandedTranslation});
                    params.setAnimationsTarget(child);
                    View label = (View)child.getTag(R.id.fab_label);
                    if (label != null) {
                        int labelXAwayFromButton = this.mLabelsPosition == 0 ? labelsXNearButton - label.getMeasuredWidth() : labelsXNearButton + label.getMeasuredWidth();
                        int labelLeft = this.mLabelsPosition == 0 ? labelXAwayFromButton : labelsXNearButton;
                        int labelRight = this.mLabelsPosition == 0 ? labelsXNearButton : labelXAwayFromButton;
                        int labelTop = childY - this.mLabelsVerticalOffset + (child.getMeasuredHeight() - label.getMeasuredHeight()) / 2;
                        label.layout(labelLeft, labelTop, labelRight, labelTop + label.getMeasuredHeight());
                        Rect touchArea = new Rect(Math.min(childX, labelLeft), childY - this.mButtonSpacing / 2, Math.max(childX + child.getMeasuredWidth(), labelRight), childY + child.getMeasuredHeight() + this.mButtonSpacing / 2);
                        this.mTouchDelegateGroup.addTouchDelegate(new TouchDelegate(touchArea, child));
                        label.setTranslationY(this.mExpanded ? expandedTranslation : collapsedTranslation);
                        label.setAlpha(this.mExpanded ? 1.0f : 0.0f);
                        LayoutParams labelParams = (LayoutParams)label.getLayoutParams();
                        labelParams.mCollapseDir.setFloatValues(new float[]{expandedTranslation, collapsedTranslation});
                        labelParams.mExpandDir.setFloatValues(new float[]{collapsedTranslation, expandedTranslation});
                        labelParams.setAnimationsTarget(label);
                    }
                    nextY = expandUp ? childY - this.mButtonSpacing : childY + child.getMeasuredHeight() + this.mButtonSpacing;
                }
                break;
            }
            case 2: 
            case 3: {
                boolean expandLeft = this.mExpandDirection == 2;
                int addButtonX = expandLeft ? r - l - this.mAddButton.getMeasuredWidth() : 0;
                int addButtonTop = b - t - this.mMaxButtonHeight + (this.mMaxButtonHeight - this.mAddButton.getMeasuredHeight()) / 2;
                this.mAddButton.layout(addButtonX, addButtonTop, addButtonX + this.mAddButton.getMeasuredWidth(), addButtonTop + this.mAddButton.getMeasuredHeight());
                int nextX = expandLeft ? addButtonX - this.mButtonSpacing : addButtonX + this.mAddButton.getMeasuredWidth() + this.mButtonSpacing;
                for (int i = this.mButtonsCount - 1; i >= 0; --i) {
                    View child = this.getChildAt(i);
                    if (child == this.mAddButton || child.getVisibility() == 8) continue;
                    int childX = expandLeft ? nextX - child.getMeasuredWidth() : nextX;
                    int childY = addButtonTop + (this.mAddButton.getMeasuredHeight() - child.getMeasuredHeight()) / 2;
                    child.layout(childX, childY, childX + child.getMeasuredWidth(), childY + child.getMeasuredHeight());
                    float collapsedTranslation = addButtonX - childX;
                    float expandedTranslation = 0.0f;
                    child.setTranslationX(this.mExpanded ? expandedTranslation : collapsedTranslation);
                    child.setAlpha(this.mExpanded ? 1.0f : 0.0f);
                    LayoutParams params = (LayoutParams)child.getLayoutParams();
                    params.mCollapseDir.setFloatValues(new float[]{expandedTranslation, collapsedTranslation});
                    params.mExpandDir.setFloatValues(new float[]{collapsedTranslation, expandedTranslation});
                    params.setAnimationsTarget(child);
                    nextX = expandLeft ? childX - this.mButtonSpacing : childX + child.getMeasuredWidth() + this.mButtonSpacing;
                }
                break;
            }
        }
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(super.generateDefaultLayoutParams());
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(super.generateLayoutParams(attrs));
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(super.generateLayoutParams(p));
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return super.checkLayoutParams(p);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bringChildToFront((View)this.mAddButton);
        this.mButtonsCount = this.getChildCount();
        if (this.mLabelsStyle != 0) {
            this.createLabels();
        }
    }

    private void createLabels() {
        ContextThemeWrapper context = new ContextThemeWrapper(this.getContext(), this.mLabelsStyle);
        for (int i = 0; i < this.mButtonsCount; ++i) {
            FloatingActionButton button = (FloatingActionButton)this.getChildAt(i);
            String title = button.getTitle();
            if (button == this.mAddButton || title == null || button.getTag(R.id.fab_label) != null) continue;
            TextView label = new TextView((Context)context);
            label.setTextAppearance(this.getContext(), this.mLabelsStyle);
            label.setText((CharSequence)button.getTitle());
            this.addView((View)label);
            button.setTag(R.id.fab_label, label);
        }
    }

    public void collapse() {
        this.collapse(false);
    }

    public void collapseImmediately() {
        this.collapse(true);
    }

    private void collapse(boolean immediately) {
        if (this.mExpanded) {
            this.mExpanded = false;
            this.mTouchDelegateGroup.setEnabled(false);
            this.mCollapseAnimation.setDuration(immediately ? 0L : 300L);
            this.mCollapseAnimation.start();
            this.mExpandAnimation.cancel();
            if (this.mListener != null) {
                this.mListener.onMenuCollapsed();
            }
        }
    }

    public void toggle() {
        if (this.mExpanded) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    public void expand() {
        if (!this.mExpanded) {
            this.mExpanded = true;
            this.mTouchDelegateGroup.setEnabled(true);
            this.mCollapseAnimation.cancel();
            this.mExpandAnimation.start();
            if (this.mListener != null) {
                this.mListener.onMenuExpanded();
            }
        }
    }

    public boolean isExpanded() {
        return this.mExpanded;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mAddButton.setEnabled(enabled);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.mExpanded = this.mExpanded;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState savedState = (SavedState)state;
            this.mExpanded = savedState.mExpanded;
            this.mTouchDelegateGroup.setEnabled(this.mExpanded);
            this.mAnimatingDrawable.setProgress(this.mExpanded ? 1.0f : 0.0f);
            super.onRestoreInstanceState(savedState.getSuperState());
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public boolean mExpanded;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable parcel) {
            super(parcel);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mExpanded = in.readInt() == 1;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mExpanded ? 1 : 0);
        }
    }

    private class LayoutParams
    extends ViewGroup.LayoutParams {
        private ObjectAnimator mExpandDir;
        private ObjectAnimator mExpandAlpha;
        private ObjectAnimator mCollapseDir;
        private ObjectAnimator mCollapseAlpha;
        private boolean animationsSetToPlay;

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
            this.mExpandDir = new ObjectAnimator();
            this.mExpandAlpha = new ObjectAnimator();
            this.mCollapseDir = new ObjectAnimator();
            this.mCollapseAlpha = new ObjectAnimator();
            this.mExpandDir.setInterpolator((TimeInterpolator)sExpandInterpolator);
            this.mExpandAlpha.setInterpolator((TimeInterpolator)sAlphaExpandInterpolator);
            this.mCollapseDir.setInterpolator((TimeInterpolator)sCollapseInterpolator);
            this.mCollapseAlpha.setInterpolator((TimeInterpolator)sCollapseInterpolator);
            this.mCollapseAlpha.setProperty(View.ALPHA);
            this.mCollapseAlpha.setFloatValues(new float[]{1.0f, 0.0f});
            this.mExpandAlpha.setProperty(View.ALPHA);
            this.mExpandAlpha.setFloatValues(new float[]{0.0f, 1.0f});
            switch (FloatingActionsMenu.this.mExpandDirection) {
                case 0: 
                case 1: {
                    this.mCollapseDir.setProperty(View.TRANSLATION_Y);
                    this.mExpandDir.setProperty(View.TRANSLATION_Y);
                    break;
                }
                case 2: 
                case 3: {
                    this.mCollapseDir.setProperty(View.TRANSLATION_X);
                    this.mExpandDir.setProperty(View.TRANSLATION_X);
                }
            }
        }

        public void setAnimationsTarget(View view) {
            this.mCollapseAlpha.setTarget((Object)view);
            this.mCollapseDir.setTarget((Object)view);
            this.mExpandAlpha.setTarget((Object)view);
            this.mExpandDir.setTarget((Object)view);
            if (!this.animationsSetToPlay) {
                this.addLayerTypeListener((Animator)this.mExpandDir, view);
                this.addLayerTypeListener((Animator)this.mCollapseDir, view);
                FloatingActionsMenu.this.mCollapseAnimation.play((Animator)this.mCollapseAlpha);
                FloatingActionsMenu.this.mCollapseAnimation.play((Animator)this.mCollapseDir);
                FloatingActionsMenu.this.mExpandAnimation.play((Animator)this.mExpandAlpha);
                FloatingActionsMenu.this.mExpandAnimation.play((Animator)this.mExpandDir);
                this.animationsSetToPlay = true;
            }
        }

        private void addLayerTypeListener(Animator animator, final View view) {
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    view.setLayerType(0, null);
                }

                public void onAnimationStart(Animator animation) {
                    view.setLayerType(2, null);
                }
            });
        }
    }

    private static class SwitchingDrawable
    extends AnimatingDrawable {
        private Drawable mStartDrawable;
        private Drawable mEndDrawable;

        public SwitchingDrawable(Drawable startDrawable) {
            super(new Drawable[]{startDrawable});
            this.mStartDrawable = startDrawable;
        }

        public SwitchingDrawable(Drawable starDrawable, Drawable endDrawable) {
            super(new Drawable[]{starDrawable, endDrawable});
            this.mStartDrawable = starDrawable;
            this.mEndDrawable = endDrawable;
        }

        public void draw(Canvas canvas) {
            if (this.mEndDrawable == null) {
                super.draw(canvas);
                return;
            }
            canvas.save();
            canvas.scale(1.0f - this.mProgress, 1.0f - this.mProgress, (float)this.getBounds().centerX(), (float)this.getBounds().centerY());
            this.mStartDrawable.draw(canvas);
            canvas.restore();
            canvas.save();
            canvas.scale(this.mProgress, this.mProgress, (float)this.getBounds().centerX(), (float)this.getBounds().centerY());
            this.mEndDrawable.draw(canvas);
            canvas.restore();
        }
    }

    private static class RotatingDrawable
    extends AnimatingDrawable {
        private final float mStartRotation;
        private final float mEndRotation;

        public RotatingDrawable(Drawable drawable2, float startRotation, float endRotation) {
            super(new Drawable[]{drawable2});
            this.mStartRotation = startRotation;
            this.mEndRotation = endRotation;
        }

        public void draw(Canvas canvas) {
            canvas.save();
            canvas.rotate(this.mStartRotation * (1.0f - this.mProgress) + this.mEndRotation * this.mProgress, (float)this.getBounds().centerX(), (float)this.getBounds().centerY());
            super.draw(canvas);
            canvas.restore();
        }
    }

    private static abstract class AnimatingDrawable
    extends LayerDrawable {
        protected float mProgress;

        public AnimatingDrawable(Drawable[] layers) {
            super(layers);
        }

        public float getProgress() {
            return this.mProgress;
        }

        public void setProgress(float progress) {
            this.mProgress = progress;
            this.invalidateSelf();
        }
    }

    public static interface OnFloatingActionsMenuUpdateListener {
        public void onMenuExpanded();

        public void onMenuCollapsed();
    }
}

