/*
 * Decompiled with CFR 0.152.
 */
package com.geopushnetwork.sdk.sync;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.ActivityManager;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SyncRequest;
import android.content.SyncResult;
import android.location.Location;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import com.geopushnetwork.sdk.GPNLib;
import com.geopushnetwork.sdk.IBeaconService;
import com.geopushnetwork.sdk.data.SDKDataContract;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationServices;
import java.util.List;

public class GPNSyncAdapter
extends AbstractThreadedSyncAdapter {
    public final String LOG_TAG = "GPN";
    public static final int SYNC_INTERVAL = 180;
    public static final int SYNC_FLEXTIME = 1;
    public static final int SYNC_VERSION = 1;

    public GPNSyncAdapter(Context context, boolean autoInitialize) {
        super(context, autoInitialize);
        SDKDataContract.Initialize(context.getPackageName() + ".gpn");
    }

    public void onPerformSync(Account account, Bundle extras, String authority, ContentProviderClient provider, SyncResult syncResult) {
        Log.d((String)"GPN", (String)"Starting sync");
        SDKDataContract.Initialize(authority);
        try {
            final GoogleApiClient mGoogleApiClient = new GoogleApiClient.Builder(this.getContext()).addApi(LocationServices.API).build();
            mGoogleApiClient.registerConnectionFailedListener(new GoogleApiClient.OnConnectionFailedListener(){

                public void onConnectionFailed(ConnectionResult connectionResult) {
                    Log.e((String)"GPN", (String)("Error connecting to google play services. Error: " + connectionResult.getErrorMessage()));
                }
            });
            mGoogleApiClient.registerConnectionCallbacks(new GoogleApiClient.ConnectionCallbacks(){

                public void onConnected(Bundle bundle) {
                    Location mLastLocation = LocationServices.FusedLocationApi.getLastLocation(mGoogleApiClient);
                    if (mLastLocation == null) {
                        Log.e((String)"GPN", (String)"Location services not enabled.");
                        GPNLib.latitude = 0.0;
                        GPNLib.longitude = 0.0;
                        class ForegroundCheckTask
                        extends AsyncTask<Context, Void, Boolean> {
                            ForegroundCheckTask() {
                            }

                            protected Boolean doInBackground(Context ... params) {
                                Context context = params[0].getApplicationContext();
                                ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
                                List appProcesses = activityManager.getRunningAppProcesses();
                                if (appProcesses != null) {
                                    String packageName = context.getPackageName();
                                    for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
                                        if (appProcess.importance != 100 || !appProcess.processName.equals(packageName)) continue;
                                        return true;
                                    }
                                }
                                return false;
                            }

                            protected void onPostExecute(Boolean aBoolean) {
                                super.onPostExecute((Object)aBoolean);
                                if (aBoolean.booleanValue()) {
                                    Toast.makeText((Context)GPNSyncAdapter.this.getContext(), (CharSequence)"Para receber ofertas mais precisas, voc\u00ea deve deixar que o Offy Gourmet obtenha a sua localiza\u00e7ao.", (int)1).show();
                                }
                            }
                        }
                        new ForegroundCheckTask().execute(new Context[]{GPNSyncAdapter.this.getContext()});
                    } else {
                        GPNLib.latitude = mLastLocation.getLatitude();
                        GPNLib.longitude = mLastLocation.getLongitude();
                    }
                    new GPNLib.RequestOfferList(GPNSyncAdapter.this.getContext()).execute(new Void[0]);
                    if (!GPNSyncAdapter.this.isMyServiceRunning(IBeaconService.class)) {
                        GPNSyncAdapter.this.getContext().startService(new Intent(GPNSyncAdapter.this.getContext(), IBeaconService.class));
                        Log.d((String)"GPN", (String)"Iniciando beacon service");
                    }
                }

                public void onConnectionSuspended(int i) {
                    Log.e((String)"GPN", (String)("Error connecting to google play was suspended. Error: " + i));
                }
            });
            mGoogleApiClient.connect();
        }
        catch (Exception exc) {
            Log.e((String)"GPN", (String)exc.toString());
        }
    }

    private boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)this.getContext().getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals("com.geopushnetwork.sdk.IBeaconService")) continue;
            return true;
        }
        return false;
    }

    public static void configurePeriodicSync(Context context, int syncInterval, int flexTime) {
        Account account = GPNSyncAdapter.getSyncAccount(context);
        String authority = context.getPackageName() + ".gpn";
        if (Build.VERSION.SDK_INT >= 19) {
            SyncRequest request = new SyncRequest.Builder().syncPeriodic((long)syncInterval, (long)flexTime).setSyncAdapter(account, authority).setExtras(new Bundle()).build();
            ContentResolver.requestSync((SyncRequest)request);
        } else {
            ContentResolver.addPeriodicSync((Account)account, (String)authority, (Bundle)new Bundle(), (long)syncInterval);
        }
    }

    public static void syncImmediately(Context context) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("expedited", true);
        bundle.putBoolean("force", true);
        String authority = context.getPackageName() + ".gpn";
        ContentResolver.requestSync((Account)GPNSyncAdapter.getSyncAccount(context), (String)authority, (Bundle)bundle);
    }

    public static Account getSyncAccount(Context context) {
        String authority;
        Account newAccount;
        AccountManager accountManager = (AccountManager)context.getSystemService("account");
        if (null == accountManager.getPassword(newAccount = new Account("GeopushSDK", authority = context.getPackageName() + ".gpn"))) {
            if (!accountManager.addAccountExplicitly(newAccount, "", null)) {
                return null;
            }
            GPNSyncAdapter.onAccountCreated(newAccount, context);
        }
        return newAccount;
    }

    private static void onAccountCreated(Account newAccount, Context context) {
        GPNSyncAdapter.configurePeriodicSync(context, 180, 1);
        String authority = context.getPackageName() + ".gpn";
        ContentResolver.setSyncAutomatically((Account)newAccount, (String)authority, (boolean)true);
        GPNSyncAdapter.syncImmediately(context);
    }

    public static void initializeSyncAdapter(Context context) {
        GPNSyncAdapter.getSyncAccount(context);
    }
}

