/*
 * Decompiled with CFR 0.152.
 */
package com.geopushnetwork.sdk;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import com.geopushnetwork.sdk.R;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.MarkerOptions;

public class LocationActivity
extends AppCompatActivity
implements OnMapReadyCallback {
    private GoogleMap mMap;
    private double latitude = 0.0;
    private double longitude = 0.0;
    private String Id = "";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_location);
        ActionBar actionBar = this.getSupportActionBar();
        actionBar.setDisplayHomeAsUpEnabled(true);
        SupportMapFragment mapFragment = (SupportMapFragment)this.getSupportFragmentManager().findFragmentById(R.id.map);
        mapFragment.getMapAsync((OnMapReadyCallback)this);
        Intent inputIntent = this.getIntent();
        this.Id = inputIntent.getStringExtra("ID");
        this.latitude = inputIntent.getDoubleExtra("LATITUDE", 0.0);
        this.longitude = inputIntent.getDoubleExtra("LONGITUDE", 0.0);
    }

    public boolean onSupportNavigateUp() {
        Intent outputIntent = new Intent();
        outputIntent.putExtra("ID", this.Id);
        this.setResult(-1, outputIntent);
        this.finish();
        return true;
    }

    public void onMapReady(GoogleMap googleMap) {
        this.mMap = googleMap;
        LatLng sydney = new LatLng(this.latitude, this.longitude);
        this.mMap.addMarker(new MarkerOptions().position(sydney).title("Sushi Rio"));
        this.mMap.moveCamera(CameraUpdateFactory.newLatLng((LatLng)sydney));
        this.mMap.moveCamera(CameraUpdateFactory.zoomTo((float)15.0f));
        this.mMap.setMyLocationEnabled(true);
        this.mMap.setIndoorEnabled(true);
        this.mMap.setBuildingsEnabled(true);
    }
}

