/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.ReaderException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.DataMask;
import com.google.zxing.qrcode.decoder.FormatInformation;
import com.google.zxing.qrcode.decoder.Version;

final class BitMatrixParser {
    private final BitMatrix bitMatrix;
    private Version parsedVersion;
    private FormatInformation parsedFormatInfo;

    BitMatrixParser(BitMatrix bitMatrix) throws ReaderException {
        int dimension = bitMatrix.getDimension();
        if (dimension < 21 || (dimension & 3) != 1) {
            throw ReaderException.getInstance();
        }
        this.bitMatrix = bitMatrix;
    }

    FormatInformation readFormatInformation() throws ReaderException {
        if (this.parsedFormatInfo != null) {
            return this.parsedFormatInfo;
        }
        int formatInfoBits = 0;
        for (int j = 0; j < 6; ++j) {
            formatInfoBits = this.copyBit(8, j, formatInfoBits);
        }
        formatInfoBits = this.copyBit(8, 7, formatInfoBits);
        formatInfoBits = this.copyBit(8, 8, formatInfoBits);
        formatInfoBits = this.copyBit(7, 8, formatInfoBits);
        for (int i = 5; i >= 0; --i) {
            formatInfoBits = this.copyBit(i, 8, formatInfoBits);
        }
        this.parsedFormatInfo = FormatInformation.decodeFormatInformation(formatInfoBits);
        if (this.parsedFormatInfo != null) {
            return this.parsedFormatInfo;
        }
        int dimension = this.bitMatrix.getDimension();
        formatInfoBits = 0;
        int iMin = dimension - 8;
        for (int i = dimension - 1; i >= iMin; --i) {
            formatInfoBits = this.copyBit(i, 8, formatInfoBits);
        }
        for (int j = dimension - 7; j < dimension; ++j) {
            formatInfoBits = this.copyBit(8, j, formatInfoBits);
        }
        this.parsedFormatInfo = FormatInformation.decodeFormatInformation(formatInfoBits);
        if (this.parsedFormatInfo != null) {
            return this.parsedFormatInfo;
        }
        throw ReaderException.getInstance();
    }

    Version readVersion() throws ReaderException {
        if (this.parsedVersion != null) {
            return this.parsedVersion;
        }
        int dimension = this.bitMatrix.getDimension();
        int provisionalVersion = dimension - 17 >> 2;
        if (provisionalVersion <= 6) {
            return Version.getVersionForNumber(provisionalVersion);
        }
        int versionBits = 0;
        for (int i = 5; i >= 0; --i) {
            int jMin = dimension - 11;
            for (int j = dimension - 9; j >= jMin; --j) {
                versionBits = this.copyBit(i, j, versionBits);
            }
        }
        this.parsedVersion = Version.decodeVersionInformation(versionBits);
        if (this.parsedVersion != null) {
            return this.parsedVersion;
        }
        versionBits = 0;
        for (int j = 5; j >= 0; --j) {
            int iMin = dimension - 11;
            for (int i = dimension - 11; i >= iMin; --i) {
                versionBits = this.copyBit(i, j, versionBits);
            }
        }
        this.parsedVersion = Version.decodeVersionInformation(versionBits);
        if (this.parsedVersion != null) {
            return this.parsedVersion;
        }
        throw ReaderException.getInstance();
    }

    private int copyBit(int i, int j, int versionBits) {
        return this.bitMatrix.get(i, j) ? versionBits << 1 | 1 : versionBits << 1;
    }

    byte[] readCodewords() throws ReaderException {
        FormatInformation formatInfo = this.readFormatInformation();
        Version version = this.readVersion();
        DataMask dataMask = DataMask.forReference(formatInfo.getDataMask());
        int dimension = this.bitMatrix.getDimension();
        dataMask.unmaskBitMatrix(this.bitMatrix.getBits(), dimension);
        BitMatrix functionPattern = version.buildFunctionPattern();
        boolean readingUp = true;
        byte[] result = new byte[version.getTotalCodewords()];
        int resultOffset = 0;
        int currentByte = 0;
        int bitsRead = 0;
        for (int j = dimension - 1; j > 0; j -= 2) {
            if (j == 6) {
                --j;
            }
            for (int count = 0; count < dimension; ++count) {
                int i = readingUp ? dimension - 1 - count : count;
                for (int col = 0; col < 2; ++col) {
                    if (functionPattern.get(i, j - col)) continue;
                    ++bitsRead;
                    currentByte <<= 1;
                    if (this.bitMatrix.get(i, j - col)) {
                        currentByte |= 1;
                    }
                    if (bitsRead != 8) continue;
                    result[resultOffset++] = (byte)currentByte;
                    bitsRead = 0;
                    currentByte = 0;
                }
            }
            readingUp ^= true;
        }
        if (resultOffset != version.getTotalCodewords()) {
            throw ReaderException.getInstance();
        }
        return result;
    }
}

