/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.AbstractOneDReader;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.ITFReader;
import com.google.zxing.oned.MultiFormatUPCEANReader;
import com.google.zxing.oned.OneDReader;
import java.util.Hashtable;
import java.util.Vector;

public final class MultiFormatOneDReader
extends AbstractOneDReader {
    private final Vector readers;

    public MultiFormatOneDReader(Hashtable hints) {
        Vector possibleFormats = hints == null ? null : (Vector)hints.get(DecodeHintType.POSSIBLE_FORMATS);
        this.readers = new Vector();
        if (possibleFormats != null) {
            if (possibleFormats.contains(BarcodeFormat.EAN_13) || possibleFormats.contains(BarcodeFormat.UPC_A) || possibleFormats.contains(BarcodeFormat.EAN_8) || possibleFormats.contains(BarcodeFormat.UPC_E)) {
                this.readers.addElement(new MultiFormatUPCEANReader(hints));
            }
            if (possibleFormats.contains(BarcodeFormat.CODE_39)) {
                this.readers.addElement(new Code39Reader());
            }
            if (possibleFormats.contains(BarcodeFormat.CODE_128)) {
                this.readers.addElement(new Code128Reader());
            }
            if (possibleFormats.contains(BarcodeFormat.ITF)) {
                this.readers.addElement(new ITFReader());
            }
        }
        if (this.readers.isEmpty()) {
            this.readers.addElement(new MultiFormatUPCEANReader(hints));
            this.readers.addElement(new Code39Reader());
            this.readers.addElement(new Code128Reader());
            this.readers.addElement(new ITFReader());
        }
    }

    public Result decodeRow(int rowNumber, BitArray row, Hashtable hints) throws ReaderException {
        int size = this.readers.size();
        for (int i = 0; i < size; ++i) {
            OneDReader reader = (OneDReader)this.readers.elementAt(i);
            try {
                return reader.decodeRow(rowNumber, row, hints);
            }
            catch (ReaderException re) {
                continue;
            }
        }
        throw ReaderException.getInstance();
    }
}

