/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ReaderException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.AbstractUPCEANReader;

public final class EAN13Reader
extends AbstractUPCEANReader {
    private static final int[] FIRST_DIGIT_ENCODINGS = new int[]{0, 11, 13, 14, 19, 25, 28, 21, 22, 26};
    private final int[] decodeMiddleCounters = new int[4];

    protected int decodeMiddle(BitArray row, int[] startRange, StringBuffer resultString) throws ReaderException {
        int[] counters = this.decodeMiddleCounters;
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int end = row.getSize();
        int rowOffset = startRange[1];
        int lgPatternFound = 0;
        for (int x = 0; x < 6 && rowOffset < end; ++x) {
            int bestMatch = EAN13Reader.decodeDigit(row, counters, rowOffset, L_AND_G_PATTERNS);
            resultString.append((char)(48 + bestMatch % 10));
            for (int i = 0; i < counters.length; ++i) {
                rowOffset += counters[i];
            }
            if (bestMatch < 10) continue;
            lgPatternFound |= 1 << 5 - x;
        }
        EAN13Reader.determineFirstDigit(resultString, lgPatternFound);
        int[] middleRange = EAN13Reader.findGuardPattern(row, rowOffset, true, MIDDLE_PATTERN);
        rowOffset = middleRange[1];
        for (int x = 0; x < 6 && rowOffset < end; ++x) {
            int bestMatch = EAN13Reader.decodeDigit(row, counters, rowOffset, L_PATTERNS);
            resultString.append((char)(48 + bestMatch));
            for (int i = 0; i < counters.length; ++i) {
                rowOffset += counters[i];
            }
        }
        return rowOffset;
    }

    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_13;
    }

    private static void determineFirstDigit(StringBuffer resultString, int lgPatternFound) throws ReaderException {
        for (int d = 0; d < 10; ++d) {
            if (lgPatternFound != FIRST_DIGIT_ENCODINGS[d]) continue;
            resultString.insert(0, (char)(48 + d));
            return;
        }
        throw ReaderException.getInstance();
    }
}

