/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.GenericResultPoint;
import com.google.zxing.oned.AbstractOneDReader;
import java.util.Hashtable;

public final class Code39Reader
extends AbstractOneDReader {
    private static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%";
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".toCharArray();
    private static final int[] CHARACTER_ENCODINGS = new int[]{52, 289, 97, 352, 49, 304, 112, 37, 292, 100, 265, 73, 328, 25, 280, 88, 13, 268, 76, 28, 259, 67, 322, 19, 274, 82, 7, 262, 70, 22, 385, 193, 448, 145, 400, 208, 133, 388, 196, 148, 168, 162, 138, 42};
    private static final int ASTERISK_ENCODING = CHARACTER_ENCODINGS[39];
    private final boolean usingCheckDigit;
    private final boolean extendedMode;

    public Code39Reader() {
        this.usingCheckDigit = false;
        this.extendedMode = false;
    }

    public Code39Reader(boolean usingCheckDigit) {
        this.usingCheckDigit = usingCheckDigit;
        this.extendedMode = false;
    }

    public Code39Reader(boolean usingCheckDigit, boolean extendedMode) {
        this.usingCheckDigit = usingCheckDigit;
        this.extendedMode = extendedMode;
    }

    public Result decodeRow(int rowNumber, BitArray row, Hashtable hints) throws ReaderException {
        int i;
        int lastStart;
        char decodedChar;
        int nextStart;
        int[] start = Code39Reader.findAsteriskPattern(row);
        int end = row.getSize();
        for (nextStart = start[1]; nextStart < end && !row.get(nextStart); ++nextStart) {
        }
        StringBuffer result = new StringBuffer();
        int[] counters = new int[9];
        do {
            Code39Reader.recordPattern(row, nextStart, counters);
            int pattern = Code39Reader.toNarrowWidePattern(counters);
            decodedChar = Code39Reader.patternToChar(pattern);
            result.append(decodedChar);
            lastStart = nextStart;
            for (i = 0; i < counters.length; ++i) {
                nextStart += counters[i];
            }
            while (nextStart < end && !row.get(nextStart)) {
                ++nextStart;
            }
        } while (decodedChar != '*');
        result.deleteCharAt(result.length() - 1);
        int lastPatternSize = 0;
        for (i = 0; i < counters.length; ++i) {
            lastPatternSize += counters[i];
        }
        int whiteSpaceAfterEnd = nextStart - lastStart - lastPatternSize;
        if (nextStart != end && whiteSpaceAfterEnd / 2 < lastPatternSize) {
            throw ReaderException.getInstance();
        }
        if (this.usingCheckDigit) {
            int max = result.length() - 1;
            int total = 0;
            for (int i2 = 0; i2 < max; ++i2) {
                total += ALPHABET_STRING.indexOf(result.charAt(i2));
            }
            if (total % 43 != ALPHABET_STRING.indexOf(result.charAt(max))) {
                throw ReaderException.getInstance();
            }
            result.deleteCharAt(max);
        }
        String resultString = result.toString();
        if (this.extendedMode) {
            resultString = Code39Reader.decodeExtended(resultString);
        }
        if (resultString.length() == 0) {
            throw ReaderException.getInstance();
        }
        float left = (float)(start[1] + start[0]) / 2.0f;
        float right = (float)(nextStart + lastStart) / 2.0f;
        return new Result(resultString, null, new ResultPoint[]{new GenericResultPoint(left, rowNumber), new GenericResultPoint(right, rowNumber)}, BarcodeFormat.CODE_39);
    }

    private static int[] findAsteriskPattern(BitArray row) throws ReaderException {
        int rowOffset;
        int width = row.getSize();
        for (rowOffset = 0; rowOffset < width && !row.get(rowOffset); ++rowOffset) {
        }
        int counterPosition = 0;
        int[] counters = new int[9];
        int patternStart = rowOffset;
        boolean isWhite = false;
        int patternLength = counters.length;
        for (int i = rowOffset; i < width; ++i) {
            boolean pixel = row.get(i);
            if (pixel ^ isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
                continue;
            }
            if (counterPosition == patternLength - 1) {
                try {
                    if (Code39Reader.toNarrowWidePattern(counters) == ASTERISK_ENCODING && row.isRange(Math.max(0, patternStart - (i - patternStart) / 2), patternStart, false)) {
                        return new int[]{patternStart, i};
                    }
                }
                catch (ReaderException re) {
                    // empty catch block
                }
                patternStart += counters[0] + counters[1];
                for (int y = 2; y < patternLength; ++y) {
                    counters[y - 2] = counters[y];
                }
                counters[patternLength - 2] = 0;
                counters[patternLength - 1] = 0;
                --counterPosition;
            } else {
                ++counterPosition;
            }
            counters[counterPosition] = 1;
            isWhite ^= true;
        }
        throw ReaderException.getInstance();
    }

    private static int toNarrowWidePattern(int[] counters) throws ReaderException {
        int wideCounters;
        int numCounters = counters.length;
        int maxNarrowCounter = 0;
        do {
            int counter;
            int i;
            int minCounter = Integer.MAX_VALUE;
            for (int i2 = 0; i2 < numCounters; ++i2) {
                int counter2 = counters[i2];
                if (counter2 >= minCounter || counter2 <= maxNarrowCounter) continue;
                minCounter = counter2;
            }
            maxNarrowCounter = minCounter;
            wideCounters = 0;
            int totalWideCountersWidth = 0;
            int pattern = 0;
            for (i = 0; i < numCounters; ++i) {
                counter = counters[i];
                if (counters[i] <= maxNarrowCounter) continue;
                pattern |= 1 << numCounters - 1 - i;
                ++wideCounters;
                totalWideCountersWidth += counter;
            }
            if (wideCounters != 3) continue;
            for (i = 0; i < numCounters && wideCounters > 0; ++i) {
                counter = counters[i];
                if (counters[i] <= maxNarrowCounter) continue;
                --wideCounters;
                if (counter << 1 < totalWideCountersWidth) continue;
                throw ReaderException.getInstance();
            }
            return pattern;
        } while (wideCounters > 3);
        throw ReaderException.getInstance();
    }

    private static char patternToChar(int pattern) throws ReaderException {
        for (int i = 0; i < CHARACTER_ENCODINGS.length; ++i) {
            if (CHARACTER_ENCODINGS[i] != pattern) continue;
            return ALPHABET[i];
        }
        throw ReaderException.getInstance();
    }

    private static String decodeExtended(String encoded) throws ReaderException {
        int length = encoded.length();
        StringBuffer decoded = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = encoded.charAt(i);
            if (c == '+' || c == '$' || c == '%' || c == '/') {
                char next = encoded.charAt(i + 1);
                int decodedChar = 0;
                switch (c) {
                    case '+': {
                        if (next >= 'A' && next <= 'Z') {
                            decodedChar = (char)(next + 32);
                            break;
                        }
                        throw ReaderException.getInstance();
                    }
                    case '$': {
                        if (next >= 'A' && next <= 'Z') {
                            decodedChar = (char)(next - 64);
                            break;
                        }
                        throw ReaderException.getInstance();
                    }
                    case '%': {
                        if (next >= 'A' && next <= 'E') {
                            decodedChar = (char)(next - 38);
                            break;
                        }
                        if (next >= 'F' && next <= 'W') {
                            decodedChar = (char)(next - 11);
                            break;
                        }
                        throw ReaderException.getInstance();
                    }
                    case '/': {
                        if (next >= 'A' && next <= 'O') {
                            decodedChar = (char)(next - 32);
                            break;
                        }
                        if (next == 'Z') {
                            decodedChar = 58;
                            break;
                        }
                        throw ReaderException.getInstance();
                    }
                }
                decoded.append((char)decodedChar);
                ++i;
                continue;
            }
            decoded.append(c);
        }
        return decoded.toString();
    }
}

