/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.GenericResultPoint;
import com.google.zxing.oned.AbstractOneDReader;
import com.google.zxing.oned.UPCEANReader;
import java.util.Hashtable;

public abstract class AbstractUPCEANReader
extends AbstractOneDReader
implements UPCEANReader {
    private static final int MAX_AVG_VARIANCE = 107;
    private static final int MAX_INDIVIDUAL_VARIANCE = 179;
    private static final int[] START_END_PATTERN;
    static final int[] MIDDLE_PATTERN;
    static final int[][] L_PATTERNS;
    static final int[][] L_AND_G_PATTERNS;
    private final StringBuffer decodeRowStringBuffer = new StringBuffer(20);

    protected AbstractUPCEANReader() {
    }

    static int[] findStartGuardPattern(BitArray row) throws ReaderException {
        boolean foundStart = false;
        int[] startRange = null;
        int nextStart = 0;
        while (!foundStart) {
            startRange = AbstractUPCEANReader.findGuardPattern(row, nextStart, false, START_END_PATTERN);
            int start = startRange[0];
            int quietStart = start - ((nextStart = startRange[1]) - start);
            if (quietStart < 0) continue;
            foundStart = row.isRange(quietStart, start, false);
        }
        return startRange;
    }

    public final Result decodeRow(int rowNumber, BitArray row, Hashtable hints) throws ReaderException {
        return this.decodeRow(rowNumber, row, AbstractUPCEANReader.findStartGuardPattern(row));
    }

    public final Result decodeRow(int rowNumber, BitArray row, int[] startGuardRange) throws ReaderException {
        StringBuffer result = this.decodeRowStringBuffer;
        result.setLength(0);
        int endStart = this.decodeMiddle(row, startGuardRange, result);
        int[] endRange = this.decodeEnd(row, endStart);
        int end = endRange[1];
        int quietEnd = end + (end - endRange[0]);
        if (quietEnd >= row.getSize() || !row.isRange(end, quietEnd, false)) {
            throw ReaderException.getInstance();
        }
        String resultString = result.toString();
        if (!this.checkChecksum(resultString)) {
            throw ReaderException.getInstance();
        }
        float left = (float)(startGuardRange[1] + startGuardRange[0]) / 2.0f;
        float right = (float)(endRange[1] + endRange[0]) / 2.0f;
        return new Result(resultString, null, new ResultPoint[]{new GenericResultPoint(left, rowNumber), new GenericResultPoint(right, rowNumber)}, this.getBarcodeFormat());
    }

    abstract BarcodeFormat getBarcodeFormat();

    boolean checkChecksum(String s) throws ReaderException {
        return AbstractUPCEANReader.checkStandardUPCEANChecksum(s);
    }

    public static boolean checkStandardUPCEANChecksum(String s) throws ReaderException {
        int digit;
        int i;
        int length = s.length();
        if (length == 0) {
            return false;
        }
        int sum = 0;
        for (i = length - 2; i >= 0; i -= 2) {
            digit = s.charAt(i) - 48;
            if (digit < 0 || digit > 9) {
                throw ReaderException.getInstance();
            }
            sum += digit;
        }
        sum *= 3;
        for (i = length - 1; i >= 0; i -= 2) {
            digit = s.charAt(i) - 48;
            if (digit < 0 || digit > 9) {
                throw ReaderException.getInstance();
            }
            sum += digit;
        }
        return sum % 10 == 0;
    }

    protected abstract int decodeMiddle(BitArray var1, int[] var2, StringBuffer var3) throws ReaderException;

    int[] decodeEnd(BitArray row, int endStart) throws ReaderException {
        return AbstractUPCEANReader.findGuardPattern(row, endStart, false, START_END_PATTERN);
    }

    static int[] findGuardPattern(BitArray row, int rowOffset, boolean whiteFirst, int[] pattern) throws ReaderException {
        int patternLength = pattern.length;
        int[] counters = new int[patternLength];
        int width = row.getSize();
        boolean isWhite = false;
        while (rowOffset < width) {
            boolean bl = isWhite = !row.get(rowOffset);
            if (whiteFirst == isWhite) break;
            ++rowOffset;
        }
        int counterPosition = 0;
        int patternStart = rowOffset;
        for (int x = rowOffset; x < width; ++x) {
            boolean pixel = row.get(x);
            if (pixel ^ isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
                continue;
            }
            if (counterPosition == patternLength - 1) {
                if (AbstractUPCEANReader.patternMatchVariance(counters, pattern, 179) < 107) {
                    return new int[]{patternStart, x};
                }
                patternStart += counters[0] + counters[1];
                for (int y = 2; y < patternLength; ++y) {
                    counters[y - 2] = counters[y];
                }
                counters[patternLength - 2] = 0;
                counters[patternLength - 1] = 0;
                --counterPosition;
            } else {
                ++counterPosition;
            }
            counters[counterPosition] = 1;
            isWhite ^= true;
        }
        throw ReaderException.getInstance();
    }

    static int decodeDigit(BitArray row, int[] counters, int rowOffset, int[][] patterns) throws ReaderException {
        AbstractUPCEANReader.recordPattern(row, rowOffset, counters);
        int bestVariance = 107;
        int bestMatch = -1;
        int max = patterns.length;
        for (int i = 0; i < max; ++i) {
            int[] pattern = patterns[i];
            int variance = AbstractUPCEANReader.patternMatchVariance(counters, pattern, 179);
            if (variance >= bestVariance) continue;
            bestVariance = variance;
            bestMatch = i;
        }
        if (bestMatch >= 0) {
            return bestMatch;
        }
        throw ReaderException.getInstance();
    }

    static {
        int i;
        START_END_PATTERN = new int[]{1, 1, 1};
        MIDDLE_PATTERN = new int[]{1, 1, 1, 1, 1};
        L_PATTERNS = new int[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
        L_AND_G_PATTERNS = new int[20][];
        for (i = 0; i < 10; ++i) {
            AbstractUPCEANReader.L_AND_G_PATTERNS[i] = L_PATTERNS[i];
        }
        for (i = 10; i < 20; ++i) {
            int[] widths = L_PATTERNS[i - 10];
            int[] reversedWidths = new int[widths.length];
            for (int j = 0; j < widths.length; ++j) {
                reversedWidths[j] = widths[widths.length - j - 1];
            }
            AbstractUPCEANReader.L_AND_G_PATTERNS[i] = reversedWidths;
        }
    }
}

