/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.detector;

import com.google.zxing.BlackPointEstimationMethod;
import com.google.zxing.MonochromeBitmapSource;
import com.google.zxing.ReaderException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.GenericResultPoint;

public final class MonochromeRectangleDetector {
    private static final int MAX_MODULES = 32;
    private final MonochromeBitmapSource image;

    public MonochromeRectangleDetector(MonochromeBitmapSource image) {
        this.image = image;
    }

    public ResultPoint[] detect() throws ReaderException {
        if (!BlackPointEstimationMethod.TWO_D_SAMPLING.equals(this.image.getLastEstimationMethod())) {
            this.image.estimateBlackPoint(BlackPointEstimationMethod.TWO_D_SAMPLING, 0);
        }
        int height = this.image.getHeight();
        int width = this.image.getWidth();
        int halfHeight = height >> 1;
        int halfWidth = width >> 1;
        int iSkip = Math.max(1, height / 256);
        int jSkip = Math.max(1, width / 256);
        int minI = 0;
        int maxI = height;
        int minJ = 0;
        int maxJ = width;
        ResultPoint pointA = this.findCornerFromCenter(halfHeight, -iSkip, minI, maxI, halfWidth, 0, minJ, maxJ, halfWidth >> 1);
        minI = (int)pointA.getY() - 1;
        ResultPoint pointB = this.findCornerFromCenter(halfHeight, 0, minI, maxI, halfWidth, -jSkip, minJ, maxJ, halfHeight >> 1);
        minJ = (int)pointB.getX() - 1;
        ResultPoint pointC = this.findCornerFromCenter(halfHeight, 0, minI, maxI, halfWidth, jSkip, minJ, maxJ, halfHeight >> 1);
        maxJ = (int)pointC.getX() + 1;
        ResultPoint pointD = this.findCornerFromCenter(halfHeight, iSkip, minI, maxI, halfWidth, 0, minJ, maxJ, halfWidth >> 1);
        maxI = (int)pointD.getY() + 1;
        pointA = this.findCornerFromCenter(halfHeight, -iSkip, minI, maxI, halfWidth, 0, minJ, maxJ, halfWidth >> 2);
        return new ResultPoint[]{pointA, pointB, pointC, pointD};
    }

    private ResultPoint findCornerFromCenter(int centerI, int di, int minI, int maxI, int centerJ, int dj, int minJ, int maxJ, int maxWhiteRun) throws ReaderException {
        int[] lastRange = null;
        int i = centerI;
        for (int j = centerJ; i < maxI && i >= minI && j < maxJ && j >= minJ; i += di, j += dj) {
            int[] range = dj == 0 ? this.blackWhiteRange(i, maxWhiteRun, minJ, maxJ, true) : this.blackWhiteRange(j, maxWhiteRun, minI, maxI, false);
            if (range == null) {
                if (lastRange == null) {
                    throw ReaderException.getInstance();
                }
                if (dj == 0) {
                    int lastI = i - di;
                    if (lastRange[0] < centerJ) {
                        if (lastRange[1] > centerJ) {
                            return new GenericResultPoint(di > 0 ? (float)lastRange[0] : (float)lastRange[1], lastI);
                        }
                        return new GenericResultPoint(lastRange[0], lastI);
                    }
                    return new GenericResultPoint(lastRange[1], lastI);
                }
                int lastJ = j - dj;
                if (lastRange[0] < centerI) {
                    if (lastRange[1] > centerI) {
                        return new GenericResultPoint(lastJ, dj < 0 ? (float)lastRange[0] : (float)lastRange[1]);
                    }
                    return new GenericResultPoint(lastJ, lastRange[0]);
                }
                return new GenericResultPoint(lastJ, lastRange[1]);
            }
            lastRange = range;
        }
        throw ReaderException.getInstance();
    }

    private int[] blackWhiteRange(int fixedDimension, int maxWhiteRun, int minDim, int maxDim, boolean horizontal) {
        int center = (minDim + maxDim) / 2;
        BitArray rowOrColumn = horizontal ? this.image.getBlackRow(fixedDimension, null, 0, this.image.getWidth()) : this.image.getBlackColumn(fixedDimension, null, 0, this.image.getHeight());
        int start = center;
        while (start >= minDim) {
            if (rowOrColumn.get(start)) {
                --start;
                continue;
            }
            int whiteRunStart = start;
            while (--start >= minDim && !rowOrColumn.get(start)) {
            }
            int whiteRunSize = whiteRunStart - start;
            if (start >= minDim && whiteRunSize <= maxWhiteRun) continue;
            start = whiteRunStart + 1;
            break;
        }
        ++start;
        int end = center;
        while (end < maxDim) {
            if (rowOrColumn.get(end)) {
                ++end;
                continue;
            }
            int whiteRunStart = end;
            while (++end < maxDim && !rowOrColumn.get(end)) {
            }
            int whiteRunSize = end - whiteRunStart;
            if (end < maxDim && whiteRunSize <= maxWhiteRun) continue;
            end = whiteRunStart - 1;
            break;
        }
        if (--end > start) {
            return new int[]{start, end};
        }
        return null;
    }
}

