/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.MonochromeBitmapSource;
import com.google.zxing.ReaderException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DefaultGridSampler;

public abstract class GridSampler {
    private static GridSampler gridSampler = null;

    public static void setGridSampler(GridSampler newGridSampler) {
        if (newGridSampler == null) {
            throw new IllegalArgumentException();
        }
        gridSampler = newGridSampler;
    }

    public static GridSampler getInstance() {
        if (gridSampler == null) {
            gridSampler = new DefaultGridSampler();
        }
        return gridSampler;
    }

    public abstract BitMatrix sampleGrid(MonochromeBitmapSource var1, int var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18) throws ReaderException;

    protected static void checkAndNudgePoints(MonochromeBitmapSource image, float[] points) throws ReaderException {
        int y;
        int x;
        int offset;
        int width = image.getWidth();
        int height = image.getHeight();
        boolean nudged = true;
        for (offset = 0; offset < points.length && nudged; offset += 2) {
            x = (int)points[offset];
            y = (int)points[offset + 1];
            if (x < -1 || x > width || y < -1 || y > height) {
                throw ReaderException.getInstance();
            }
            nudged = false;
            if (x == -1) {
                points[offset] = 0.0f;
                nudged = true;
            } else if (x == width) {
                points[offset] = width - 1;
                nudged = true;
            }
            if (y == -1) {
                points[offset + 1] = 0.0f;
                nudged = true;
                continue;
            }
            if (y != height) continue;
            points[offset + 1] = height - 1;
            nudged = true;
        }
        nudged = true;
        for (offset = points.length - 2; offset >= 0 && nudged; offset -= 2) {
            x = (int)points[offset];
            y = (int)points[offset + 1];
            if (x < -1 || x > width || y < -1 || y > height) {
                throw ReaderException.getInstance();
            }
            nudged = false;
            if (x == -1) {
                points[offset] = 0.0f;
                nudged = true;
            } else if (x == width) {
                points[offset] = width - 1;
                nudged = true;
            }
            if (y == -1) {
                points[offset + 1] = 0.0f;
                nudged = true;
                continue;
            }
            if (y != height) continue;
            points[offset + 1] = height - 1;
            nudged = true;
        }
    }
}

