/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.MonochromeBitmapSource;
import com.google.zxing.ReaderException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.PerspectiveTransform;

public final class DefaultGridSampler
extends GridSampler {
    public BitMatrix sampleGrid(MonochromeBitmapSource image, int dimension, float p1ToX, float p1ToY, float p2ToX, float p2ToY, float p3ToX, float p3ToY, float p4ToX, float p4ToY, float p1FromX, float p1FromY, float p2FromX, float p2FromY, float p3FromX, float p3FromY, float p4FromX, float p4FromY) throws ReaderException {
        PerspectiveTransform transform = PerspectiveTransform.quadrilateralToQuadrilateral(p1ToX, p1ToY, p2ToX, p2ToY, p3ToX, p3ToY, p4ToX, p4ToY, p1FromX, p1FromY, p2FromX, p2FromY, p3FromX, p3FromY, p4FromX, p4FromY);
        BitMatrix bits = new BitMatrix(dimension);
        float[] points = new float[dimension << 1];
        for (int i = 0; i < dimension; ++i) {
            int j;
            int max = points.length;
            float iValue = (float)i + 0.5f;
            for (j = 0; j < max; j += 2) {
                points[j] = (float)(j >> 1) + 0.5f;
                points[j + 1] = iValue;
            }
            transform.transformPoints(points);
            DefaultGridSampler.checkAndNudgePoints(image, points);
            try {
                for (j = 0; j < max; j += 2) {
                    if (!image.isBlack((int)points[j], (int)points[j + 1])) continue;
                    bits.set(i, j >> 1);
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw ReaderException.getInstance();
            }
        }
        return bits;
    }
}

