/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.ReaderException;

public final class BlackPointEstimator {
    private BlackPointEstimator() {
    }

    public static int estimate(int[] histogram) throws ReaderException {
        int numBuckets = histogram.length;
        int maxBucketCount = 0;
        int firstPeak = 0;
        int firstPeakSize = 0;
        for (int i = 0; i < numBuckets; ++i) {
            if (histogram[i] > firstPeakSize) {
                firstPeak = i;
                firstPeakSize = histogram[i];
            }
            if (histogram[i] <= maxBucketCount) continue;
            maxBucketCount = histogram[i];
        }
        int secondPeak = 0;
        int secondPeakScore = 0;
        for (int i = 0; i < numBuckets; ++i) {
            int distanceToBiggest = i - firstPeak;
            int score = histogram[i] * distanceToBiggest * distanceToBiggest;
            if (score <= secondPeakScore) continue;
            secondPeak = i;
            secondPeakScore = score;
        }
        if (firstPeak > secondPeak) {
            int temp = firstPeak;
            firstPeak = secondPeak;
            secondPeak = temp;
        }
        if (secondPeak - firstPeak <= numBuckets >> 4) {
            throw ReaderException.getInstance();
        }
        int bestValley = secondPeak - 1;
        int bestValleyScore = -1;
        for (int i = secondPeak - 1; i > firstPeak; --i) {
            int fromFirst = i - firstPeak;
            int score = fromFirst * fromFirst * (secondPeak - i) * (maxBucketCount - histogram[i]);
            if (score <= bestValleyScore) continue;
            bestValley = i;
            bestValleyScore = score;
        }
        return bestValley;
    }
}

